/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.mtp._internal.entity.message;

import im.actor.api.mtp._internal.entity.ProtoStruct;
import im.actor.api.util.StreamingUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RpcResponseBox
extends ProtoStruct {
    public static final byte HEADER = 4;
    private long messageId;
    private byte[] payload;

    public RpcResponseBox(InputStream stream) throws IOException {
        super(stream);
    }

    public long getMessageId() {
        return this.messageId;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    public int getLength() {
        return 9 + StreamingUtils.varintSize(this.payload.length) + this.payload.length;
    }

    @Override
    protected byte getHeader() {
        return 4;
    }

    @Override
    protected void writeBody(OutputStream bs) throws IOException {
        StreamingUtils.writeLong(this.messageId, bs);
        StreamingUtils.writeProtoBytes(this.payload, bs);
    }

    @Override
    protected void readBody(InputStream bs) throws IOException {
        this.messageId = StreamingUtils.readLong(bs);
        this.payload = StreamingUtils.readProtoBytes(bs);
    }

    public String toString() {
        return "ResponseBox [" + this.messageId + "]";
    }
}

