/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.mtp._internal.tcp;

import com.droidkit.actors.ActorRef;
import im.actor.api.LogInterface;
import im.actor.api.mtp.MTProtoEndpoint;
import im.actor.api.mtp.MTProtoParams;
import im.actor.api.mtp._internal.tcp.RawTcpConnection;
import im.actor.api.util.StreamingUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.CRC32;
import javax.net.ssl.SSLSocketFactory;

public class TcpConnection
implements RawTcpConnection {
    private static final AtomicInteger NEXT_ID = new AtomicInteger(1);
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int READ_DIE_TIMEOUT = 15000;
    private static final int MAX_PACKAGE_SIZE = 0x100000;
    private static final AtomicInteger PACKAGE = new AtomicInteger(1);
    private final String TAG;
    private final LogInterface LOG;
    private final boolean DEBUG;
    private final Socket socket;
    private final ReaderThread readerThread;
    private final WriterThread writerThread;
    private final DieThread dieThread;
    private final ActorRef receiver;
    private final int connectionId;
    private final MTProtoParams params;
    private int sentPackets;
    private int receivedPackets;
    private boolean isClosed;
    private boolean isBroken;
    private long lastWriteEvent = 0L;

    public TcpConnection(MTProtoEndpoint endpoint, MTProtoParams params, ActorRef receiver) throws IOException {
        try {
            this.connectionId = NEXT_ID.incrementAndGet();
            this.params = params;
            this.TAG = "TcpConnection#" + this.connectionId;
            this.LOG = params.getConfig().getLogInterface();
            this.DEBUG = params.getConfig().isDebugTcp();
            this.socket = endpoint.getEndpointType() == MTProtoEndpoint.EndpointType.PLAIN_TCP ? new Socket() : SSLSocketFactory.getDefault().createSocket();
            this.socket.connect(new InetSocketAddress(endpoint.getHost(), endpoint.getPort()), 5000);
            this.socket.getInputStream();
            if (!params.getConfig().isChromeEnabled()) {
                this.socket.setKeepAlive(true);
                this.socket.setTcpNoDelay(true);
            }
            this.isClosed = false;
            this.isBroken = false;
            this.receiver = receiver;
            this.readerThread = new ReaderThread();
            this.writerThread = new WriterThread();
            this.dieThread = new DieThread();
            this.readerThread.start();
            this.writerThread.start();
            this.dieThread.start();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException();
        }
    }

    @Override
    public int getConnectionId() {
        return this.connectionId;
    }

    public int getSentPackets() {
        return this.sentPackets;
    }

    public int getReceivedPackets() {
        return this.receivedPackets;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isBroken() {
        return this.isBroken;
    }

    @Override
    public void postMessage(byte[] data) {
        this.writerThread.pushPackage(new Package(data));
    }

    @Override
    public synchronized void close() {
        block10: {
            if (!this.isClosed) {
                block9: {
                    block8: {
                        if (this.LOG != null) {
                            this.LOG.w(this.TAG, "Manual context closing");
                        }
                        this.isClosed = true;
                        this.isBroken = false;
                        try {
                            this.readerThread.interrupt();
                        }
                        catch (Exception e) {
                            if (this.LOG == null) break block8;
                            this.LOG.e(this.TAG, e);
                        }
                    }
                    try {
                        this.writerThread.interrupt();
                    }
                    catch (Exception e) {
                        if (this.LOG == null) break block9;
                        this.LOG.e(this.TAG, e);
                    }
                }
                try {
                    this.dieThread.interrupt();
                }
                catch (Exception e) {
                    if (this.LOG == null) break block10;
                    this.LOG.e(this.TAG, e);
                }
            }
        }
    }

    private synchronized void onMessage(byte[] data, int len) {
        if (this.isClosed) {
            if (this.LOG != null) {
                this.LOG.w(this.TAG, "Ignoring package: connection closed");
            }
            return;
        }
        int id = PACKAGE.incrementAndGet();
        if (this.LOG != null && this.DEBUG) {
            this.LOG.d(this.TAG, "Sending #" + id);
        }
        this.receiver.send((Object)new RawMessage(id, data, 0, len, this.connectionId));
    }

    private synchronized void breakConnection() {
        block13: {
            if (!this.isClosed) {
                block12: {
                    block11: {
                        block10: {
                            if (this.LOG != null) {
                                this.LOG.w(this.TAG, "Breaking connection");
                            }
                            this.isClosed = true;
                            this.isBroken = true;
                            try {
                                this.readerThread.interrupt();
                            }
                            catch (Exception e) {
                                if (this.LOG == null) break block10;
                                this.LOG.e(this.TAG, e);
                            }
                        }
                        try {
                            this.writerThread.interrupt();
                        }
                        catch (Exception e) {
                            if (this.LOG == null) break block11;
                            this.LOG.e(this.TAG, e);
                        }
                    }
                    try {
                        this.dieThread.interrupt();
                    }
                    catch (Exception e) {
                        if (this.LOG == null) break block12;
                        this.LOG.e(this.TAG, e);
                    }
                }
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    if (this.LOG == null) break block13;
                    this.LOG.e(this.TAG, e);
                }
            }
        }
        this.receiver.send((Object)new ConnectionDie(this.getConnectionId()));
    }

    private void onWrite() {
        this.lastWriteEvent = System.currentTimeMillis();
        this.notifyDieThread();
    }

    private void onRead() {
        this.lastWriteEvent = 0L;
        this.notifyDieThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDieThread() {
        DieThread dieThread = this.dieThread;
        synchronized (dieThread) {
            this.dieThread.notifyAll();
        }
    }

    private byte[] readBytes(int count, InputStream stream) throws IOException {
        int readed;
        byte[] res = new byte[count];
        for (int offset = 0; offset < count; offset += readed) {
            readed = stream.read(res, offset, count - offset);
            if (readed > 0) {
                this.onRead();
                continue;
            }
            throw new IOException();
        }
        return res;
    }

    public static class ConnectionDie {
        private int contextId;

        public ConnectionDie(int contextId) {
            this.contextId = contextId;
        }

        public int getContextId() {
            return this.contextId;
        }
    }

    public static class RawMessage {
        private int id;
        private byte[] data;
        private int offset;
        private int len;
        private int contextId;

        public RawMessage(int id, byte[] data, int offset, int len, int contextId) {
            this.id = id;
            this.data = data;
            this.offset = offset;
            this.len = len;
            this.contextId = contextId;
        }

        public int getId() {
            return this.id;
        }

        public byte[] getData() {
            return this.data;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLen() {
            return this.len;
        }

        public int getContextId() {
            return this.contextId;
        }
    }

    private class DieThread
    extends Thread {
        public DieThread() {
            this.setPriority(1);
            this.setName(TcpConnection.this.TAG + "#DieThread" + this.hashCode());
        }

        @Override
        public void run() {
            while (!TcpConnection.this.isBroken) {
                if (TcpConnection.this.lastWriteEvent != 0L) {
                    long delta = System.currentTimeMillis() - TcpConnection.this.lastWriteEvent;
                    if (delta >= 15000L) {
                        if (TcpConnection.this.LOG != null) {
                            TcpConnection.this.LOG.w(TcpConnection.this.TAG, "Dies by timeout");
                        }
                        TcpConnection.this.breakConnection();
                        continue;
                    }
                    try {
                        int waitDelta = (int)(15000L - delta);
                        DieThread.sleep(Math.max(waitDelta, 1000));
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                try {
                    DieThread.sleep(15000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    private class WriterThread
    extends Thread {
        private final CRC32 crc32 = new CRC32();
        private final ConcurrentLinkedQueue<Package> packages = new ConcurrentLinkedQueue();

        public WriterThread() {
            this.setPriority(1);
            this.setName(TcpConnection.this.TAG + "#Writer" + this.hashCode());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pushPackage(Package p) {
            this.packages.add(p);
            ConcurrentLinkedQueue<Package> concurrentLinkedQueue = this.packages;
            synchronized (concurrentLinkedQueue) {
                this.packages.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!TcpConnection.this.isClosed && !this.isInterrupted()) {
                Package p;
                ConcurrentLinkedQueue<Package> concurrentLinkedQueue = this.packages;
                synchronized (concurrentLinkedQueue) {
                    p = this.packages.poll();
                    if (p == null) {
                        try {
                            this.packages.wait();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        p = this.packages.poll();
                    }
                }
                if (p == null) {
                    if (!TcpConnection.this.isBroken) continue;
                    return;
                }
                try {
                    byte[] data = p.data;
                    int length = data.length + 8;
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    StreamingUtils.writeInt(length, outputStream);
                    StreamingUtils.writeInt(TcpConnection.this.sentPackets, outputStream);
                    StreamingUtils.writeBytes(data, outputStream);
                    this.crc32.reset();
                    this.crc32.update(outputStream.toByteArray());
                    StreamingUtils.writeInt((int)this.crc32.getValue(), outputStream);
                    TcpConnection.this.socket.getOutputStream().write(outputStream.toByteArray());
                    TcpConnection.this.socket.getOutputStream().flush();
                    TcpConnection.this.onWrite();
                    TcpConnection.this.sentPackets++;
                }
                catch (Exception e) {
                    if (TcpConnection.this.LOG != null) {
                        TcpConnection.this.LOG.e(TcpConnection.this.TAG, e);
                    }
                    TcpConnection.this.breakConnection();
                }
            }
        }
    }

    private class ReaderThread
    extends Thread {
        private ReaderThread() {
            this.setPriority(1);
            this.setName(TcpConnection.this.TAG + "#Reader" + this.hashCode());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                while (!TcpConnection.this.isClosed && !this.isInterrupted()) {
                    try {
                        int expectedIndex;
                        int pkgIndex;
                        int pkgLen;
                        if (TcpConnection.this.socket.isClosed()) {
                            if (TcpConnection.this.LOG != null) {
                                TcpConnection.this.LOG.w(TcpConnection.this.TAG, "Socket is closed");
                            }
                            TcpConnection.this.breakConnection();
                            return;
                        }
                        if (!TcpConnection.this.socket.isConnected()) {
                            if (TcpConnection.this.LOG != null) {
                                TcpConnection.this.LOG.w(TcpConnection.this.TAG, "Socket is not connected");
                            }
                            TcpConnection.this.breakConnection();
                            return;
                        }
                        InputStream stream = TcpConnection.this.socket.getInputStream();
                        long start = System.currentTimeMillis();
                        if (TcpConnection.this.LOG != null && TcpConnection.this.DEBUG) {
                            TcpConnection.this.LOG.d(TcpConnection.this.TAG, "Reading content length");
                        }
                        if ((pkgLen = StreamingUtils.readInt(stream)) < 0 || pkgLen > 0x100000) {
                            if (TcpConnection.this.LOG == null) throw new IOException("Invalid package size");
                            TcpConnection.this.LOG.w(TcpConnection.this.TAG, "Invalid package size: " + pkgLen);
                            throw new IOException("Invalid package size");
                        }
                        if (TcpConnection.this.LOG != null && TcpConnection.this.DEBUG) {
                            TcpConnection.this.LOG.d(TcpConnection.this.TAG, "Reading package index");
                        }
                        if ((pkgIndex = StreamingUtils.readInt(stream)) != (expectedIndex = TcpConnection.this.receivedPackets++)) {
                            if (TcpConnection.this.LOG == null) throw new IOException("Wrong number of received packets");
                            TcpConnection.this.LOG.w(TcpConnection.this.TAG, "Wrong seq. Expected " + expectedIndex + ", got " + pkgIndex);
                            throw new IOException("Wrong number of received packets");
                        }
                        if (TcpConnection.this.LOG != null && TcpConnection.this.DEBUG) {
                            TcpConnection.this.LOG.d(TcpConnection.this.TAG, "Reading package content of " + pkgLen + " bytes");
                        }
                        byte[] pkg = TcpConnection.this.readBytes(pkgLen - 8, stream);
                        if (TcpConnection.this.LOG != null && TcpConnection.this.DEBUG) {
                            TcpConnection.this.LOG.d(TcpConnection.this.TAG, "Reading CRC32");
                        }
                        int pkgCrc = StreamingUtils.readInt(stream);
                        CRC32 crc32 = new CRC32();
                        crc32.update(StreamingUtils.intToBytes(pkgLen));
                        crc32.update(StreamingUtils.intToBytes(pkgIndex));
                        crc32.update(pkg);
                        int localCrc = (int)crc32.getValue();
                        if (localCrc != pkgCrc) {
                            if (TcpConnection.this.LOG == null) throw new IOException("Wrong CRC");
                            TcpConnection.this.LOG.w(TcpConnection.this.TAG, "Package crc32 expected: " + localCrc + ", got: " + pkgCrc);
                            throw new IOException("Wrong CRC");
                        }
                        if (TcpConnection.this.LOG != null && TcpConnection.this.DEBUG) {
                            TcpConnection.this.LOG.d(TcpConnection.this.TAG, "Read #" + pkgIndex + " in " + (System.currentTimeMillis() - start) + " ms");
                        }
                        TcpConnection.this.onMessage(pkg, pkgLen);
                    }
                    catch (IOException e) {
                        if (TcpConnection.this.LOG != null) {
                            TcpConnection.this.LOG.e(TcpConnection.this.TAG, e);
                        }
                        TcpConnection.this.breakConnection();
                        return;
                    }
                }
            }
            catch (Throwable e) {
                if (TcpConnection.this.LOG != null) {
                    TcpConnection.this.LOG.e(TcpConnection.this.TAG, e);
                }
                TcpConnection.this.breakConnection();
            }
        }
    }

    private class Package {
        public byte[] data;

        public Package() {
        }

        private Package(byte[] data) {
            this.data = data;
        }
    }
}

