/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.scheme.rpc;

import com.droidkit.bser.Bser;
import com.droidkit.bser.BserValues;
import com.droidkit.bser.BserWriter;
import im.actor.api.parser.Request;
import im.actor.api.scheme.rpc.ResponseAuthCode;
import java.io.IOException;

public class RequestAuthCode
extends Request<ResponseAuthCode> {
    public static final int HEADER = 1;
    private long phoneNumber;
    private int appId;
    private String apiKey;

    public static RequestAuthCode fromBytes(byte[] data) throws IOException {
        return (RequestAuthCode)Bser.parse(RequestAuthCode.class, (byte[])data);
    }

    public RequestAuthCode(long phoneNumber, int appId, String apiKey) {
        this.phoneNumber = phoneNumber;
        this.appId = appId;
        this.apiKey = apiKey;
    }

    public RequestAuthCode() {
    }

    public long getPhoneNumber() {
        return this.phoneNumber;
    }

    public int getAppId() {
        return this.appId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void parse(BserValues values) throws IOException {
        this.phoneNumber = values.getLong(1);
        this.appId = values.getInt(2);
        this.apiKey = values.getString(3);
    }

    public void serialize(BserWriter writer) throws IOException {
        writer.writeLong(1, this.phoneNumber);
        writer.writeInt(2, this.appId);
        if (this.apiKey == null) {
            throw new IOException();
        }
        writer.writeString(3, this.apiKey);
    }

    @Override
    public int getHeaderKey() {
        return 1;
    }
}

