/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.scheme.rpc;

import com.droidkit.bser.Bser;
import com.droidkit.bser.BserObject;
import com.droidkit.bser.BserValues;
import com.droidkit.bser.BserWriter;
import im.actor.api.parser.Request;
import im.actor.api.scheme.UploadConfig;
import im.actor.api.scheme.rpc.ResponseCompleteUpload;
import java.io.IOException;

public class RequestCompleteUpload
extends Request<ResponseCompleteUpload> {
    public static final int HEADER = 22;
    private UploadConfig config;
    private int blocksCount;
    private long crc32;

    public static RequestCompleteUpload fromBytes(byte[] data) throws IOException {
        return (RequestCompleteUpload)Bser.parse(RequestCompleteUpload.class, (byte[])data);
    }

    public RequestCompleteUpload(UploadConfig config, int blocksCount, long crc32) {
        this.config = config;
        this.blocksCount = blocksCount;
        this.crc32 = crc32;
    }

    public RequestCompleteUpload() {
    }

    public UploadConfig getConfig() {
        return this.config;
    }

    public int getBlocksCount() {
        return this.blocksCount;
    }

    public long getCrc32() {
        return this.crc32;
    }

    public void parse(BserValues values) throws IOException {
        this.config = (UploadConfig)values.getObj(1, UploadConfig.class);
        this.blocksCount = values.getInt(2);
        this.crc32 = values.getLong(3);
    }

    public void serialize(BserWriter writer) throws IOException {
        if (this.config == null) {
            throw new IOException();
        }
        writer.writeObject(1, (BserObject)this.config);
        writer.writeInt(2, this.blocksCount);
        writer.writeLong(3, this.crc32);
    }

    @Override
    public int getHeaderKey() {
        return 22;
    }
}

