/*
 * Decompiled with CFR 0.152.
 */
package im.actor.api.scheme.updates;

import com.droidkit.bser.Bser;
import com.droidkit.bser.BserObject;
import com.droidkit.bser.BserValues;
import com.droidkit.bser.BserWriter;
import im.actor.api.parser.Update;
import im.actor.api.scheme.Peer;
import java.io.IOException;

public class UpdateEncryptedReceived
extends Update {
    public static final int HEADER = 18;
    private Peer peer;
    private long rid;
    private long receivedDate;

    public static UpdateEncryptedReceived fromBytes(byte[] data) throws IOException {
        return (UpdateEncryptedReceived)Bser.parse(UpdateEncryptedReceived.class, (byte[])data);
    }

    public UpdateEncryptedReceived(Peer peer, long rid, long receivedDate) {
        this.peer = peer;
        this.rid = rid;
        this.receivedDate = receivedDate;
    }

    public UpdateEncryptedReceived() {
    }

    public Peer getPeer() {
        return this.peer;
    }

    public long getRid() {
        return this.rid;
    }

    public long getReceivedDate() {
        return this.receivedDate;
    }

    public void parse(BserValues values) throws IOException {
        this.peer = (Peer)values.getObj(1, Peer.class);
        this.rid = values.getLong(2);
        this.receivedDate = values.getLong(3);
    }

    public void serialize(BserWriter writer) throws IOException {
        if (this.peer == null) {
            throw new IOException();
        }
        writer.writeObject(1, (BserObject)this.peer);
        writer.writeLong(2, this.rid);
        writer.writeLong(3, this.receivedDate);
    }

    @Override
    public int getHeaderKey() {
        return 18;
    }
}

