/*
 * Decompiled with CFR 0.152.
 */
package im.toss.http.parser;

import im.toss.http.parser.HttpAuthCredentialParseException;
import im.toss.http.parser.KvPair;
import im.toss.http.parser.Rfc7230ListParser;
import im.toss.http.parser.TokenValidator;
import im.toss.http.parser.TokenValidatorFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAuthCredentials {
    private static final Logger log = LoggerFactory.getLogger(HttpAuthCredentials.class);
    private final String scheme;
    private final String token;
    private final Map<String, List<String>> params;

    public HttpAuthCredentials(String scheme, String token) {
        this(scheme, token, Collections.emptyMap());
    }

    public HttpAuthCredentials(String scheme, String token, Map<String, List<String>> params) {
        this.scheme = Objects.requireNonNull(scheme, "scheme must not be null");
        this.token = Objects.requireNonNull(token, "token must not be null");
        this.params = Objects.requireNonNull(params, "params must not be null");
    }

    public static HttpAuthCredentials fromSingleValueParams(String scheme, String token, Map<String, String> params) {
        Map<String, List<String>> multiValuesParams = params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.singletonList(e.getValue())));
        return new HttpAuthCredentials(scheme, token, multiValuesParams);
    }

    public static HttpAuthCredentials parse(String credentials) {
        return HttpAuthCredentials.parse(credentials, true);
    }

    public static HttpAuthCredentials parse(String credentials, boolean strict) {
        if (credentials == null) {
            return HttpAuthCredentials.none();
        }
        List<String> parts = Arrays.asList(credentials.split("\\s+", 2));
        String authScheme = parts.get(0);
        String remains = parts.size() >= 2 ? parts.get(1) : "";
        TokenValidatorFactory tokenValidatorFactory = new TokenValidatorFactory();
        TokenValidator tokenValidator = tokenValidatorFactory.create(TokenValidatorFactory.TokenType.RFC7230_TOKEN);
        TokenValidator quotedStringValidator = tokenValidatorFactory.create(TokenValidatorFactory.TokenType.RFC7230_QUOTED_STRING);
        TokenValidator token68Validator = tokenValidatorFactory.create(TokenValidatorFactory.TokenType.RFC7235_TOKEN68);
        TreeMap<String, List<String>> parameterValueByName = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        String token = "";
        Rfc7230ListParser parser = Rfc7230ListParser.parse(remains);
        for (String value : parser.values()) {
            KvPair pair = KvPair.parse(value);
            if (pair.getKey().isEmpty() || pair.getValue().isEmpty()) {
                if (token.isEmpty()) {
                    token = value;
                    continue;
                }
                HttpAuthCredentials.handleError(strict, "Multiple token68 is not allowed");
                continue;
            }
            try {
                tokenValidator.validate(pair.getKey());
                if (pair.getValue().startsWith("\"")) {
                    quotedStringValidator.validate(pair.getValue());
                } else {
                    tokenValidator.validate(pair.getValue());
                }
            }
            catch (Exception e) {
                HttpAuthCredentials.handleError(strict, "Bad parameter: " + value, e);
            }
            HttpAuthCredentials.addParameter(parameterValueByName, pair);
        }
        try {
            token68Validator.validate(token);
        }
        catch (Exception e) {
            HttpAuthCredentials.handleError(strict, "Bad token: " + token, e);
        }
        return new HttpAuthCredentials(authScheme, token, parameterValueByName);
    }

    private static void addParameter(Map<String, List<String>> parameterValueByName, KvPair pair) {
        List<String> values = parameterValueByName.get(pair.getKey());
        if (values == null) {
            values = new ArrayList<String>();
        }
        values.add(pair.getValue());
        parameterValueByName.put(pair.getKey(), values);
    }

    private static void handleError(boolean strict, String message) {
        if (strict) {
            throw new HttpAuthCredentialParseException(message);
        }
        log.warn(message);
    }

    private static void handleError(boolean strict, String message, Exception e) {
        if (strict) {
            throw new HttpAuthCredentialParseException(message, e);
        }
        log.warn(message);
    }

    public static HttpAuthCredentials none() {
        return new HttpAuthCredentials("", "");
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getToken() {
        return this.token;
    }

    public Map<String, List<String>> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    public Map<String, String> getSingleValueParams() {
        return Collections.unmodifiableMap(this.getParams().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((List)e.getValue()).get(0))));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpAuthCredentials that = (HttpAuthCredentials)o;
        return Objects.equals(this.scheme, that.scheme) && Objects.equals(this.token, that.token) && Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.token, this.params);
    }

    public String toString() {
        return "HttpAuthCredentials{scheme='" + this.scheme + '\'' + ", token='" + this.token + '\'' + ", params=" + this.params + '}';
    }
}

