/*
 * Decompiled with CFR 0.152.
 */
package im.toss.http.parser;

import im.toss.http.parser.Rfc7230ListParserException;
import java.util.ArrayList;
import java.util.List;

public class Rfc7230ListParser {
    private final String input;
    private final List<String> values;
    private StringBuilder valueBuilder;

    Rfc7230ListParser(String input) {
        this.input = input;
        this.values = new ArrayList<String>();
        this.valueBuilder = new StringBuilder();
    }

    public static Rfc7230ListParser parse(String input) {
        Rfc7230ListParser parser = new Rfc7230ListParser(input);
        parser.parse();
        return parser;
    }

    private void parse() {
        boolean inQuotedPair = false;
        boolean inQuotedString = false;
        for (char ch : this.input.toCharArray()) {
            switch (ch) {
                case '\"': {
                    this.valueBuilder.append(ch);
                    if (inQuotedPair) break;
                    boolean bl = inQuotedString = !inQuotedString;
                    if (inQuotedString) break;
                    this.closeValue();
                    break;
                }
                case ',': {
                    if (inQuotedString || inQuotedPair) {
                        this.valueBuilder.append(ch);
                        break;
                    }
                    this.closeValue();
                    break;
                }
                default: {
                    this.valueBuilder.append(ch);
                }
            }
            inQuotedPair = !inQuotedPair && ch == '\\';
        }
        if (inQuotedPair) {
            throw new Rfc7230ListParserException("Unclosed quoted pair");
        }
        if (inQuotedString) {
            throw new Rfc7230ListParserException("Unclosed quoted string");
        }
        this.closeValue();
    }

    private void closeValue() {
        String value = this.valueBuilder.toString().trim();
        if (!value.isEmpty()) {
            this.values.add(value);
        }
        this.valueBuilder = new StringBuilder();
    }

    public List<String> values() {
        return this.values;
    }
}

