/*
 * Decompiled with CFR 0.152.
 */
package im.toss.http.parser;

import im.toss.http.parser.AbstractTokenValidator;
import im.toss.http.parser.TokenValidationException;

class Rfc7230QuotedStringValidator
extends AbstractTokenValidator {
    Rfc7230QuotedStringValidator() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void validate(String quotedString) {
        State state = State.BEGIN;
        int pos = 0;
        block14: for (char ch : quotedString.toCharArray()) {
            block0 : switch (state) {
                case BEGIN: {
                    if (ch != '\"') {
                        throw new TokenValidationException(this.unexpectedCharacterError(ch, pos));
                    }
                    state = State.QUOTED_STRING;
                    break;
                }
                case QUOTED_STRING: {
                    switch (ch) {
                        case '\\': {
                            state = State.QUOTED_PAIR;
                            break block0;
                        }
                        case '\"': {
                            state = State.END;
                            break block0;
                        }
                    }
                    if (this.isQdText(ch)) break;
                    throw new TokenValidationException(this.unexpectedCharacterError(ch, pos));
                }
                case QUOTED_PAIR: {
                    if (ch != ' ' && ch != '\t' && !this.isObsText(ch) && !this.isVchar(ch)) {
                        throw new TokenValidationException(this.unexpectedCharacterError(ch, pos));
                    }
                    state = State.QUOTED_STRING;
                    continue block14;
                }
                case END: {
                    throw new TokenValidationException(this.unexpectedCharacterError(ch, pos));
                }
            }
            ++pos;
        }
        switch (state) {
            case QUOTED_STRING: {
                throw new TokenValidationException("Unclosed quoted string");
            }
            case QUOTED_PAIR: {
                throw new TokenValidationException("Unclosed quoted pair");
            }
        }
    }

    private boolean isQdText(char ch) {
        return ch == '\t' || ch == ' ' || this.isVchar(ch) && ch != '\"' && ch != '\\' || this.isObsText(ch);
    }

    private boolean isVchar(char ch) {
        return ch >= '!' && ch <= '~';
    }

    private boolean isObsText(char ch) {
        return ch >= '\u0080' && ch <= '\u00ff';
    }

    static enum State {
        BEGIN,
        QUOTED_STRING,
        QUOTED_PAIR,
        END;

    }
}

