/*
 * Decompiled with CFR 0.152.
 */
package in.abilng.ndjson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import in.abilng.ndjson.internal.NdJsonRunTimeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class NdJsonObjectMapper {
    private ObjectMapper objectMapper = null;

    public NdJsonObjectMapper() {
        this.objectMapper = new ObjectMapper();
    }

    public NdJsonObjectMapper(JsonFactory jf) {
        this.objectMapper = new ObjectMapper(jf);
    }

    public NdJsonObjectMapper(JsonFactory jf, DefaultSerializerProvider sp, DefaultDeserializationContext dc) {
        this.objectMapper = new ObjectMapper(jf, sp, dc);
    }

    public NdJsonObjectMapper registerModule(Module module) {
        this.objectMapper.registerModule(module);
        return this;
    }

    public NdJsonObjectMapper registerModules(Module ... modules) {
        for (Module module : modules) {
            this.registerModule(module);
        }
        return this;
    }

    public <T> Stream<T> readValue(InputStream in, Class<T> valueType) throws NdJsonRunTimeException, JsonParseException, JsonMappingException {
        Objects.requireNonNull(in, "InputStream cannot be null");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        return reader.lines().filter(StringUtils::isNotEmpty).map(json -> this.jsonToObject((String)json, valueType));
    }

    public <T> List<T> readValueAsList(InputStream in, Class<T> valueType) throws NdJsonRunTimeException, JsonParseException, JsonMappingException {
        return this.readValue(in, valueType).collect(Collectors.toList());
    }

    public void writeValue(OutputStream out, Stream<Object> value) throws NdJsonRunTimeException, JsonGenerationException, JsonMappingException {
        Objects.requireNonNull(out, "OutPutStream cannot be null");
        value.forEach(val -> this.objectToJson(out, val));
    }

    public void writeValue(OutputStream out, List<Object> value) throws NdJsonRunTimeException, JsonGenerationException, JsonMappingException {
        Objects.requireNonNull(out, "OutPutStream cannot be null");
        value.forEach(val -> this.objectToJson(out, val));
    }

    private void objectToJson(OutputStream out, Object val) {
        try {
            this.objectMapper.writeValue(out, val);
        }
        catch (IOException e) {
            throw new NdJsonRunTimeException(e);
        }
    }

    private <T> T jsonToObject(String json, Class<T> valueType) {
        try {
            return (T)this.objectMapper.readValue(json, valueType);
        }
        catch (IOException e) {
            throw new NdJsonRunTimeException(e);
        }
    }
}

