/*
 * Decompiled with CFR 0.152.
 */
package com.tw.go.plugin.jgit;

import com.tw.go.plugin.GitHelper;
import com.tw.go.plugin.cmd.InMemoryConsumer;
import com.tw.go.plugin.cmd.ProcessOutputStreamConsumer;
import com.tw.go.plugin.model.GitConfig;
import com.tw.go.plugin.model.ModifiedFile;
import com.tw.go.plugin.model.Revision;
import com.tw.go.plugin.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.commons.io.FileUtils;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CleanCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.GarbageCollectCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.SubmoduleAddCommand;
import org.eclipse.jgit.api.SubmoduleStatusCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.lib.SubmoduleConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.submodule.SubmoduleStatus;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.io.DisabledOutputStream;

public class JGitHelper
extends GitHelper {
    public JGitHelper(GitConfig gitConfig, File workingDir) {
        this(gitConfig, workingDir, new ProcessOutputStreamConsumer(new InMemoryConsumer()), new ProcessOutputStreamConsumer(new InMemoryConsumer()));
    }

    public JGitHelper(GitConfig gitConfig, File workingDir, ProcessOutputStreamConsumer stdOut, ProcessOutputStreamConsumer stdErr) {
        super(gitConfig, workingDir, stdOut, stdErr);
    }

    @Override
    public String version() {
        return "5.5.1.201910021850-r";
    }

    @Override
    public void checkConnection() {
        try {
            LsRemoteCommand lsRemote = Git.lsRemoteRepository().setHeads(true).setRemote(this.gitConfig.getUrl());
            this.setCredentials((TransportCommand)lsRemote);
            lsRemote.call();
        }
        catch (Exception e) {
            throw new RuntimeException("check connection (ls-remote) failed", e);
        }
    }

    @Override
    public void cloneRepository() {
        CloneCommand clone = Git.cloneRepository().setURI(this.gitConfig.getUrl()).setBranch(this.gitConfig.getEffectiveBranch()).setDirectory(this.workingDir);
        if (this.gitConfig.isNoCheckout()) {
            this.stdOut.consumeLine("JGit implementation does not support noCheckout; cloning full...");
        }
        if (this.gitConfig.isShallowClone()) {
            this.stdOut.consumeLine("JGit implementation does not support shallow clones; cloning full...");
        }
        if (this.gitConfig.isRecursiveSubModuleUpdate()) {
            clone.setCloneSubmodules(true);
        }
        this.setCredentials((TransportCommand)clone);
        try {
            clone.call();
        }
        catch (Exception e) {
            throw new RuntimeException("clone failed", e);
        }
    }

    @Override
    public void checkoutRemoteBranchToLocal() {
        try (Repository repository = this.getRepository(this.workingDir);){
            Git git = new Git(repository);
            CheckoutCommand checkout = git.checkout().setForceRefUpdate(true).setName(this.gitConfig.getEffectiveBranch());
            checkout.call();
        }
        catch (Exception e) {
            throw new RuntimeException("checkout failed", e);
        }
    }

    @Override
    public String workingRepositoryUrl() {
        String string;
        block8: {
            Repository repository = this.getRepository(this.workingDir);
            try {
                string = repository.getConfig().getString("remote", "origin", "url");
                if (repository == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("clean failed", e);
                }
            }
            repository.close();
        }
        return string;
    }

    @Override
    public String getCurrentBranch() {
        String string;
        block8: {
            Repository repository = this.getRepository(this.workingDir);
            try {
                string = repository.getBranch();
                if (repository == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("current branch failed", e);
                }
            }
            repository.close();
        }
        return string;
    }

    @Override
    public int getCommitCount() {
        int n;
        block8: {
            Repository repository = this.getRepository(this.workingDir);
            try {
                Git git = new Git(repository);
                n = (int)StreamSupport.stream(git.log().call().spliterator(), false).count();
                if (repository == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("commit count failed", e);
                }
            }
            repository.close();
        }
        return n;
    }

    @Override
    public String currentRevision() {
        return this.getLatestRevision().getRevision();
    }

    @Override
    public List<Revision> getAllRevisions() {
        ArrayList<Revision> arrayList;
        block9: {
            Repository repository = this.getRepository(this.workingDir);
            try {
                Git git = new Git(repository);
                LogCommand logCmd = git.log();
                Iterable log = logCmd.call();
                ArrayList<Revision> revisionObjs = new ArrayList<Revision>();
                for (RevCommit commit : log) {
                    Revision revisionObj = this.getRevisionObj(repository, commit);
                    revisionObjs.add(revisionObj);
                }
                arrayList = revisionObjs;
                if (repository == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("get all revisions failed", e);
                }
            }
            repository.close();
        }
        return arrayList;
    }

    @Override
    public Revision getLatestRevision() {
        return this.getLatestRevision(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Revision getLatestRevision(List<String> subPaths) {
        try (Repository repository = this.getRepository(this.workingDir);){
            Git git = new Git(repository);
            LogCommand logCmd = git.log().setMaxCount(1);
            this.addPathsToLogCommand(logCmd, subPaths);
            Iterable log = logCmd.call();
            Iterator iterator = log.iterator();
            if (!iterator.hasNext()) return null;
            Revision revision = this.getRevisionObj(repository, (RevCommit)iterator.next());
            return revision;
        }
        catch (Exception e) {
            throw new RuntimeException("get latest revision failed", e);
        }
    }

    @Override
    public List<Revision> getRevisionsSince(String previousRevision) {
        return this.getRevisionsSince(previousRevision, null);
    }

    @Override
    public List<Revision> getRevisionsSince(String previousRevision, List<String> subPaths) {
        ArrayList<Revision> arrayList;
        block11: {
            Repository repository = this.getRepository(this.workingDir);
            try {
                RevCommit commit;
                Git git = new Git(repository);
                LogCommand logCmd = git.log();
                this.addPathsToLogCommand(logCmd, subPaths);
                Iterable log = logCmd.call();
                ArrayList<RevCommit> newCommits = new ArrayList<RevCommit>();
                Iterator iterator = log.iterator();
                while (iterator.hasNext() && !(commit = (RevCommit)iterator.next()).getName().equals(previousRevision)) {
                    newCommits.add(commit);
                }
                ArrayList<Revision> revisionObjs = new ArrayList<Revision>();
                if (!newCommits.isEmpty()) {
                    for (RevCommit newCommit : newCommits) {
                        Revision revisionObj = this.getRevisionObj(repository, newCommit);
                        revisionObjs.add(revisionObj);
                    }
                }
                arrayList = revisionObjs;
                if (repository == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("get newer revisions failed", e);
                }
            }
            repository.close();
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Revision getDetailsForRevision(String sha) {
        try (Repository repository = this.getRepository(this.workingDir);){
            Git git = new Git(repository);
            LogCommand logCmd = git.log().all();
            Iterable log = logCmd.call();
            for (RevCommit commit : log) {
                if (!commit.getName().equals(sha)) continue;
                Revision revision = this.getRevisionObj(repository, commit);
                return revision;
            }
            Iterator iterator = null;
            return iterator;
        }
        catch (Exception e) {
            throw new RuntimeException("get latest revision failed", e);
        }
    }

    @Override
    public Map<String, String> getBranchToRevisionMap(String pattern) {
        HashMap<String, String> hashMap;
        block9: {
            Repository repository = this.getRepository(this.workingDir);
            try {
                Map allRefs = repository.getAllRefs();
                HashMap<String, String> branchToRevisionMap = new HashMap<String, String>();
                for (String refName : allRefs.keySet()) {
                    if (!refName.contains(pattern)) continue;
                    String branch = refName.replace(pattern, "");
                    String revision = ((Ref)allRefs.get(refName)).getObjectId().getName();
                    branchToRevisionMap.put(branch, revision);
                }
                hashMap = branchToRevisionMap;
                if (repository == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("fetch failed", e);
                }
            }
            repository.close();
        }
        return hashMap;
    }

    @Override
    public void pull() {
    }

    @Override
    public void fetch(String refSpec) {
        try (Repository repository = this.getRepository(this.workingDir);){
            Git git = new Git(repository);
            FetchCommand fetch = git.fetch().setRemoveDeletedRefs(true).setRecurseSubmodules(SubmoduleConfig.FetchRecurseSubmodulesMode.NO);
            if (!StringUtil.isEmpty(refSpec)) {
                fetch.setRefSpecs(new RefSpec[]{new RefSpec(refSpec)});
            }
            this.setCredentials((TransportCommand)fetch);
            fetch.call();
        }
        catch (Exception e) {
            throw new RuntimeException("fetch failed", e);
        }
    }

    @Override
    public void resetHard(String revision) {
        try (Repository repository = this.getRepository(this.workingDir);){
            Git git = new Git(repository);
            ResetCommand reset = git.reset().setMode(ResetCommand.ResetType.HARD).setRef(revision);
            reset.call();
        }
        catch (Exception e) {
            throw new RuntimeException("reset failed", e);
        }
    }

    @Override
    protected boolean shouldReset() {
        return true;
    }

    @Override
    public void cleanAllUnversionedFiles() {
        try (Repository repository = this.getRepository(this.workingDir);
             Git git = new Git(repository);
             SubmoduleWalk walk = SubmoduleWalk.forIndex((Repository)repository);){
            while (walk.next()) {
                this.cleanSubmoduleOfAllUnversionedFiles(walk);
            }
            CleanCommand clean = git.clean().setCleanDirectories(true);
            clean.call();
        }
        catch (Exception e) {
            throw new RuntimeException("clean failed", e);
        }
    }

    private void cleanSubmoduleOfAllUnversionedFiles(SubmoduleWalk walk) {
        try (Repository submoduleRepository = walk.getRepository();){
            if (submoduleRepository != null) {
                CleanCommand clean = Git.wrap((Repository)submoduleRepository).clean().setCleanDirectories(true);
                clean.call();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("sub-module clean failed", e);
        }
    }

    @Override
    public void gc() {
        try (Repository repository = this.getRepository(this.workingDir);){
            Git git = new Git(repository);
            GarbageCollectCommand gc = git.gc();
            gc.call();
        }
        catch (Exception e) {
            throw new RuntimeException("gc failed", e);
        }
    }

    @Override
    public Map<String, String> submoduleUrls() {
        return null;
    }

    @Override
    public List<String> submoduleFolders() {
        ArrayList<String> arrayList;
        block8: {
            Repository repository = this.getRepository(this.workingDir);
            try {
                Git git = new Git(repository);
                SubmoduleStatusCommand submoduleStatus = git.submoduleStatus();
                Map submoduleStatusMap = submoduleStatus.call();
                arrayList = new ArrayList<String>(submoduleStatusMap.keySet());
                if (repository == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("sub-module folders list failed", e);
                }
            }
            repository.close();
        }
        return arrayList;
    }

    @Override
    public void printSubmoduleStatus() {
        try (Repository repository = this.getRepository(this.workingDir);){
            Git git = new Git(repository);
            SubmoduleStatusCommand submoduleStatus = git.submoduleStatus();
            Map submoduleStatusMap = submoduleStatus.call();
            for (String submoduleFolder : submoduleStatusMap.keySet()) {
                this.stdOut.consumeLine(submoduleFolder + " " + ((SubmoduleStatus)submoduleStatusMap.get(submoduleFolder)).getType());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("sub-module print status failed", e);
        }
    }

    @Override
    public void checkoutAllModifiedFilesInSubmodules() {
        try (Repository repository = this.getRepository(this.workingDir);
             SubmoduleWalk walk = SubmoduleWalk.forIndex((Repository)repository);){
            while (walk.next()) {
                this.checkoutSubmodule(walk);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("checkout all sub-modules failed", e);
        }
    }

    private void checkoutSubmodule(SubmoduleWalk walk) {
        try (Repository submoduleRepository = walk.getRepository();){
            CheckoutCommand checkout = Git.wrap((Repository)submoduleRepository).checkout().setForceRefUpdate(true).setName("HEAD");
            checkout.call();
        }
        catch (Exception e) {
            throw new RuntimeException("sub-module checkout failed", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getSubModuleCommitCount(String subModuleFolder) {
        try (Repository repository = this.getRepository(this.workingDir);){
            int n;
            block14: {
                Repository subModuleRepository = SubmoduleWalk.getSubmoduleRepository((Repository)repository, (String)subModuleFolder);
                try {
                    Git git = new Git(subModuleRepository);
                    n = (int)StreamSupport.stream(git.log().call().spliterator(), false).count();
                    if (subModuleRepository == null) break block14;
                }
                catch (Throwable throwable) {
                    if (subModuleRepository != null) {
                        try {
                            subModuleRepository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                subModuleRepository.close();
            }
            return n;
        }
        catch (Exception e) {
            throw new RuntimeException("sub-module commit count failed", e);
        }
    }

    @Override
    public void submoduleInit() {
        try (Repository repository = this.getRepository(this.workingDir);){
            Git git = new Git(repository);
            git.submoduleInit().call();
        }
        catch (Exception e) {
            throw new RuntimeException("sub-module init failed", e);
        }
    }

    @Override
    public void submoduleSync() {
        try (Repository repository = this.getRepository(this.workingDir);){
            Git git = new Git(repository);
            git.submoduleSync().call();
        }
        catch (Exception e) {
            throw new RuntimeException("sub-module sync failed", e);
        }
    }

    @Override
    public void submoduleUpdate() {
        try (Repository repository = this.getRepository(this.workingDir);){
            Git git = new Git(repository);
            git.submoduleUpdate().call();
        }
        catch (Exception e) {
            throw new RuntimeException("sub-module update failed", e);
        }
    }

    @Override
    public void init() {
        try {
            Git.init().setDirectory(this.workingDir).call();
            FileRepositoryBuilder.create((File)new File(this.workingDir.getAbsolutePath(), ".git")).close();
        }
        catch (Exception e) {
            throw new RuntimeException("init failed", e);
        }
    }

    @Override
    public void add(File fileToAdd) {
        try (Repository repository = this.getRepository(this.workingDir);){
            Git git = new Git(repository);
            AddCommand add = git.add().addFilepattern(fileToAdd.getName());
            add.call();
        }
        catch (Exception e) {
            throw new RuntimeException("add failed", e);
        }
    }

    @Override
    public void commit(String message) {
        try (Repository repository = this.getRepository(this.workingDir);){
            Git git = new Git(repository);
            CommitCommand commit = git.commit().setAuthor("author", "author@nodomain.com").setSign(Boolean.valueOf(false)).setMessage(message);
            commit.call();
        }
        catch (Exception e) {
            throw new RuntimeException("commit failed", e);
        }
    }

    @Override
    public void commitOnDate(String message, Date commitDate) {
    }

    @Override
    public void submoduleAdd(String subModuleFolder, String subModuleName, String relativePath) {
        try (Repository parentRepository = this.getRepository(this.workingDir);
             Repository subModuleRepository = this.getRepository(new File(subModuleFolder));){
            Git git = new Git(parentRepository);
            SubmoduleAddCommand subModuleAdd = git.submoduleAdd().setURI(subModuleRepository.getDirectory().getCanonicalPath()).setPath(relativePath);
            subModuleAdd.call();
        }
        catch (Exception e) {
            throw new RuntimeException("add sub-module failed", e);
        }
    }

    @Override
    public void removeSubmoduleSectionsFromGitConfig() {
        List<String> submoduleFolders = this.submoduleFolders();
        for (String submoduleFolder : submoduleFolders) {
            this.configRemoveSection(submoduleFolder);
        }
    }

    @Override
    public void submoduleRemove(String folderName) {
        this.configRemoveSection(folderName);
        try (Repository repository = this.getRepository(this.workingDir);){
            FileBasedConfig gitSubmodulesConfig = new FileBasedConfig(null, new File(repository.getWorkTree(), ".gitmodules"), FS.DETECTED);
            gitSubmodulesConfig.unsetSection("submodule", folderName);
            gitSubmodulesConfig.save();
            Git git = Git.wrap((Repository)repository);
            git.rm().setCached(true).addFilepattern(folderName).call();
            FileUtils.deleteQuietly((File)new File(this.workingDir, folderName));
        }
        catch (Exception e) {
            throw new RuntimeException("sub-module remove failed", e);
        }
    }

    private void configRemoveSection(String folderName) {
        try (Repository repository = this.getRepository(this.workingDir);){
            StoredConfig repositoryConfig = repository.getConfig();
            repositoryConfig.unsetSection("submodule", folderName);
            repositoryConfig.save();
        }
        catch (Exception e) {
            throw new RuntimeException("sub-module section remove failed", e);
        }
    }

    @Override
    public void changeSubmoduleUrl(String submoduleName, String newUrl) {
    }

    @Override
    public void push() {
    }

    private void addPathsToLogCommand(LogCommand logCmd, List<String> subPaths) {
        if (subPaths != null) {
            subPaths.stream().map(String::trim).forEach(arg_0 -> ((LogCommand)logCmd).addPath(arg_0));
        }
    }

    private Revision getRevisionObj(Repository repository, RevCommit commit) throws IOException {
        String commitSHA = commit.getName();
        Date commitTime = commit.getAuthorIdent().getWhen();
        String comment = commit.getFullMessage().trim();
        String user = commit.getAuthorIdent().getName();
        String emailId = commit.getAuthorIdent().getEmailAddress();
        ArrayList<ModifiedFile> modifiedFiles = new ArrayList<ModifiedFile>();
        if (commit.getParentCount() == 0) {
            TreeWalk treeWalk = new TreeWalk(repository);
            treeWalk.addTree((AnyObjectId)commit.getTree());
            treeWalk.setRecursive(false);
            while (treeWalk.next()) {
                modifiedFiles.add(new ModifiedFile(treeWalk.getPathString(), "added"));
            }
        } else {
            RevWalk rw = new RevWalk(repository);
            RevCommit parent = rw.parseCommit((AnyObjectId)commit.getParent(0).getId());
            DiffFormatter diffFormatter = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
            diffFormatter.setRepository(repository);
            diffFormatter.setDiffComparator(RawTextComparator.DEFAULT);
            diffFormatter.setDetectRenames(true);
            List diffEntries = diffFormatter.scan(parent.getTree(), commit.getTree());
            for (DiffEntry diffEntry : diffEntries) {
                modifiedFiles.add(new ModifiedFile(diffEntry.getNewPath(), this.getAction(diffEntry.getChangeType().name())));
            }
        }
        boolean isMergeCommit = commit.getParentCount() > 1;
        Revision revision = new Revision(commitSHA, commitTime, comment, user, emailId, modifiedFiles);
        revision.setMergeCommit(isMergeCommit);
        return revision;
    }

    private String getAction(String gitAction) {
        if (gitAction.equalsIgnoreCase("ADD") || gitAction.equalsIgnoreCase("RENAME")) {
            return "added";
        }
        if (gitAction.equals("MODIFY")) {
            return "modified";
        }
        if (gitAction.equals("DELETE")) {
            return "deleted";
        }
        return "unknown";
    }

    private Repository getRepository(File folder) throws IOException {
        return ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(this.getGitDir(folder))).readEnvironment()).findGitDir()).build();
    }

    private File getGitDir(File folder) {
        return new File(folder, ".git");
    }

    private void setCredentials(TransportCommand command) {
        if (this.gitConfig.isRemoteUrl() && this.gitConfig.hasCredentials()) {
            command.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.gitConfig.getUsername(), this.gitConfig.getPassword()));
        }
    }
}

