/*
 * Decompiled with CFR 0.152.
 */
package in.bottomhalf.ps.database.models;

import in.bottomhalf.ps.database.models.DatabaseProperties;
import in.bottomhalf.ps.database.models.MultiDataSourceProperties;
import jakarta.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
@DependsOn(value={"databaseProperties", "multiDataSourceProperties"})
public class DataSourceConfiguration {
    @Autowired
    DatabaseProperties databaseProperties;
    @Autowired
    MultiDataSourceProperties multiDataSourceProperties;

    @PostConstruct
    public void ConfigureDatabase() throws Exception {
        if (this.databaseProperties == null) {
            throw new Exception("Fail to construct the database fields class");
        }
        if (this.multiDataSourceProperties == null) {
            throw new Exception("Fail to construct the database manager");
        }
        if (this.databaseProperties.getUrl() != null) {
            this.databaseProperties.validate();
            this.multiDataSourceProperties.getConnections().put("default", this.databaseProperties);
        } else {
            if (this.multiDataSourceProperties.getConnections().isEmpty()) {
                throw new Exception("Database configuration not found");
            }
            this.multiDataSourceProperties.getConnections().forEach((key, value) -> {
                try {
                    value.validate();
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                    throw new RuntimeException("Database configuration detail not found or missing field for: " + key);
                }
            });
        }
    }
}

