/*
 * Decompiled with CFR 0.152.
 */
package in.bottomhalf.ps.database.models;

import jakarta.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="spring.datasource")
public class DatabaseProperties {
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private String database;

    @PostConstruct
    public void init() throws Exception {
        System.out.println("DataSourceConfig loaded successfully!");
    }

    public void validate() throws Exception {
        if (this.isNullOrEmpty(this.driverClassName)) {
            throw new Exception("Database property 'driverClassName' is missing or empty");
        }
        if (this.isNullOrEmpty(this.url)) {
            throw new Exception("Database property 'jdbcUrl' is missing or empty");
        }
        if (this.isNullOrEmpty(this.username)) {
            throw new Exception("Database property 'username' is missing or empty");
        }
        if (this.isNullOrEmpty(this.password)) {
            throw new Exception("Database property 'password' is missing or empty");
        }
        if (this.isNullOrEmpty(this.database)) {
            throw new Exception("Database property 'database' is missing or empty");
        }
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }
}

