/*
 * Decompiled with CFR 0.152.
 */
package in.bottomhalf.ps.database.models;

import in.bottomhalf.ps.database.models.DatabaseProperties;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsNotFoundException;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="spring.datasource")
public class MultiDataSourceProperties {
    private Map<String, DatabaseProperties> connections = new HashMap<String, DatabaseProperties>();

    @PostConstruct
    public void init() {
        if (this.connections.isEmpty()) {
            System.out.println("MultiDataSourceConfig not found!");
        } else {
            System.out.println("MultiDataSourceConfig loaded successfully!");
        }
    }

    public void validate() {
        if (this.connections.isEmpty()) {
            throw new ConnectionDetailsNotFoundException("No database configuration found. Please add 'spring.database.connections' property in your application (.yml or .properties) file.");
        }
    }

    public Map<String, DatabaseProperties> getConnections() {
        return this.connections;
    }

    public DatabaseProperties getConfig(String name) {
        if (this.connections == null || this.connections.isEmpty()) {
            throw new ConnectionDetailsNotFoundException("No database configuration found with name [" + name + "]. Please add 'spring.database' property in your application (.yml or .properties) file.");
        }
        if (!this.connections.containsKey(name)) {
            return this.connections.entrySet().iterator().next().getValue();
        }
        return this.connections.get(name);
    }

    public void setConnections(Map<String, DatabaseProperties> connections) {
        this.connections = connections;
    }

    public List<DatabaseProperties> asList() {
        return new ArrayList<DatabaseProperties>(this.connections.values());
    }
}

