/*
 * Decompiled with CFR 0.152.
 */
package in.bottomhalf.ps.database.service;

import in.bottomhalf.ps.database.annotations.Column;
import in.bottomhalf.ps.database.annotations.Id;
import in.bottomhalf.ps.database.annotations.Table;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@Component
@RequestScope
public class DbUtils {
    public <T> String save(T instance) throws Exception {
        String tableName = this.getTableName(instance);
        String primayKey = this.getPrimaryKey(instance);
        HashMap<String, Field> fields = this.getFields(instance);
        StringBuilder columnsName = new StringBuilder();
        columnsName.append("INSERT INTO ").append(tableName).append("(");
        StringBuilder columnsValue = new StringBuilder();
        columnsValue.append("VALUES(");
        StringBuilder updateStatement = new StringBuilder();
        try {
            String delimiter = "";
            String updateDelimiter = "";
            for (Map.Entry<String, Field> field : fields.entrySet()) {
                field.getValue().setAccessible(true);
                Object value = field.getValue().get(instance);
                Class<?> type = field.getValue().getType();
                columnsName.append(delimiter + field.getKey());
                if (type == String.class) {
                    if (value != null) {
                        value = "'" + value + "'";
                    }
                } else if (type == Date.class && value != null) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    value = "'" + formatter.format(value) + "'";
                }
                columnsValue.append(delimiter + value);
                if (!field.getKey().equals(primayKey)) {
                    updateStatement.append(updateDelimiter + field.getKey() + " = " + value);
                    updateDelimiter = ",";
                }
                delimiter = ",";
            }
            columnsName.append(") ");
            columnsValue.append(") ON DUPLICATE KEY UPDATE ");
        }
        catch (IllegalAccessException ex) {
            throw new Exception(ex.getMessage());
        }
        return columnsName.toString() + columnsValue.toString() + updateStatement.toString();
    }

    public <T> String saveAll(List<T> instances, Class<T> classType) throws Exception {
        T instanceType = classType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        String tableName = this.getTableName(instanceType);
        String primayKey = this.getPrimaryKey(instanceType);
        HashMap<String, Field> fields = this.getFields(instanceType);
        StringBuilder columnsName = new StringBuilder();
        StringBuilder columnsValue = new StringBuilder();
        StringBuilder updateStatement = new StringBuilder();
        try {
            String delimiter = "";
            String rowDelimiter = "";
            int i = 0;
            for (T instance : instances) {
                columnsValue.append(rowDelimiter + "(");
                delimiter = "";
                String updateDelimiter = "";
                for (Map.Entry<String, Field> field : fields.entrySet()) {
                    field.getValue().setAccessible(true);
                    Object value = field.getValue().get(instance);
                    Class<?> type = field.getValue().getType();
                    if (type == String.class) {
                        if (value != null) {
                            value = "'" + value + "'";
                        }
                    } else if (type == Date.class && value != null) {
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        value = "'" + formatter.format(value) + "'";
                    }
                    columnsValue.append(delimiter + value);
                    if (i == 0) {
                        columnsName.append(delimiter + field.getKey());
                        if (!field.getKey().equals(primayKey)) {
                            updateStatement.append(updateDelimiter + field.getKey() + " = VALUES(" + field.getKey() + ")");
                            updateDelimiter = ",";
                        }
                    }
                    delimiter = ",";
                }
                columnsValue.append(")");
                rowDelimiter = ",";
                ++i;
            }
        }
        catch (IllegalAccessException ex) {
            throw new Exception(ex.getMessage());
        }
        return "INSERT INTO " + tableName + "(" + columnsName + ") VALUES " + columnsValue + " ON DUPLICATE KEY UPDATE " + updateStatement;
    }

    public <T> String lastPrimaryKey(Class<T> type) throws Exception {
        T instance = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        String primaryKeyName = this.getPrimaryKey(instance);
        String tableName = this.getTableName(instance);
        return "select " + primaryKeyName + " from " + tableName + " Order by " + primaryKeyName + " desc limit 1";
    }

    public <T> String get(Class<T> type) throws Exception {
        T instance = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        String tableName = this.getTableName(instance);
        return this.createSelectStatement(instance, tableName);
    }

    public <T> String getById(String id, Class<T> type) throws Exception {
        T instance = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        String primaryKey = this.getPrimaryKey(instance);
        String tableName = this.getTableName(instance);
        return this.createSelectStatement(instance, tableName) + " WHERE " + primaryKey + " = '" + id + "'";
    }

    public <T> String getById(long id, Class<T> type) throws Exception {
        T instance = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        String primaryKey = this.getPrimaryKey(instance);
        String tableName = this.getTableName(instance);
        return this.createSelectStatement(instance, tableName) + " WHERE " + primaryKey + " = " + id;
    }

    public <T> String getById(int id, Class<T> type) throws Exception {
        T instance = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        String primaryKey = this.getPrimaryKey(instance);
        String tableName = this.getTableName(instance);
        return this.createSelectStatement(instance, tableName) + " WHERE " + primaryKey + " = " + id;
    }

    public <T> String getPrimaryKey(T instance) throws Exception {
        Field[] fields;
        String primaryKey = null;
        for (Field field : fields = instance.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Id.class) || !field.isAnnotationPresent(Column.class)) continue;
            Column column = field.getAnnotation(Column.class);
            primaryKey = column.name();
            break;
        }
        if (primaryKey == null) {
            throw new Exception("Modal does not have primary key declared.");
        }
        return primaryKey;
    }

    private <T> String getTableName(T instance) throws Exception {
        Annotation[] annotations;
        String tableName = null;
        for (Annotation annotation : annotations = instance.getClass().getAnnotations()) {
            if (!annotation.annotationType().equals(Table.class)) continue;
            tableName = ((Table)annotation).name();
            break;
        }
        if (tableName == null) {
            throw new Exception("Modal does not have table name declared.");
        }
        return tableName;
    }

    private <T> String createSelectStatement(T instance, String tableName) throws Exception {
        HashMap<String, Field> fields = this.getFields(instance);
        StringBuilder columnsName = new StringBuilder();
        columnsName.append("SELECT ");
        try {
            String delimiter = "";
            for (Map.Entry<String, Field> field : fields.entrySet()) {
                columnsName.append(delimiter + field.getKey());
                delimiter = ",";
            }
            columnsName.append(" FROM " + tableName);
        }
        catch (Exception ex) {
            throw new Exception(ex.getMessage());
        }
        return columnsName.toString();
    }

    private <T> HashMap<String, Field> getFields(T instance) {
        Field[] fields;
        HashMap<String, Field> fieldsCollection = new HashMap<String, Field>();
        for (Field field : fields = instance.getClass().getDeclaredFields()) {
            Optional<Column> annotation = Arrays.stream((Column[])field.getAnnotationsByType(Column.class)).findFirst();
            annotation.ifPresent(column -> fieldsCollection.put(column.name(), field));
        }
        return fieldsCollection;
    }
}

