/*
 * Decompiled with CFR 0.152.
 */
package in.bottomhalf.ps.database.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import in.bottomhalf.ps.database.models.DatabaseProperties;
import in.bottomhalf.ps.database.models.MultiDataSourceProperties;
import in.bottomhalf.ps.database.utils.DbParameters;
import in.bottomhalf.ps.database.utils.Template;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.simple.SimpleJdbcCall;
import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.RequestScope;

@Component
@RequestScope(proxyMode=ScopedProxyMode.TARGET_CLASS)
public class DbProcedureManager {
    @Autowired
    ObjectMapper mapper;
    @Autowired
    DatabaseProperties databaseProperties;
    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public DbProcedureManager(MultiDataSourceProperties multiDataSourceProperties) {
        Template template = new Template();
        this.jdbcTemplate = template.getTemplate(multiDataSourceProperties.getConfig("default"));
    }

    public <T> T convertType(Map<String, Object> resultSet, Class<T> clazz) {
        CollectionType type = TypeFactory.defaultInstance().constructCollectionType(List.class, clazz);
        List result = (List)this.mapper.convertValue(resultSet.get("#result-set-1"), (JavaType)type);
        if (result.isEmpty()) {
            return null;
        }
        return (T)result.get(0);
    }

    public <T> T execute(String procedureName, List<DbParameters> sqlParams, Class<T> tClass) throws Exception {
        Map<String, Object> resultSet = this.executeProcedure(procedureName, sqlParams);
        CollectionType type = TypeFactory.defaultInstance().constructCollectionType(List.class, tClass);
        List result = (List)this.mapper.convertValue(resultSet.get("#result-set-1"), (JavaType)type);
        if (result.isEmpty()) {
            return null;
        }
        return (T)result.get(0);
    }

    public <T> List<T> getList(String procedureName, Class<T> tClass, DbParameters ... sqlParams) throws Exception {
        Map<String, Object> resultSet = this.executeProcedure(procedureName, Arrays.stream(sqlParams).toList());
        CollectionType type = TypeFactory.defaultInstance().constructCollectionType(List.class, tClass);
        List result = (List)this.mapper.convertValue(resultSet.get("#result-set-1"), (JavaType)type);
        if (result.isEmpty()) {
            return new ArrayList();
        }
        return result;
    }

    public <T> List<T> getRecords(String procedureName, List<DbParameters> sqlParams, Class<T> tClass) throws Exception {
        Map<String, Object> resultSet = this.executeProcedure(procedureName, sqlParams);
        CollectionType type = TypeFactory.defaultInstance().constructCollectionType(List.class, tClass);
        return (List)this.mapper.convertValue(resultSet.get("#result-set-1"), (JavaType)type);
    }

    public <T> Map<String, Object> executeProcedure(String procedureName, List<DbParameters> sqlParams) throws Exception {
        SimpleJdbcCall simpleJdbcCall = new SimpleJdbcCall(this.jdbcTemplate).withCatalogName(this.databaseProperties.getDatabase()).withProcedureName(procedureName);
        HashMap<String, Object> paramSet = new HashMap<String, Object>();
        try {
            for (DbParameters dbParameters : sqlParams) {
                paramSet.put(dbParameters.parameter, dbParameters.value);
                simpleJdbcCall.addDeclaredParameter(new SqlParameter(dbParameters.parameter, dbParameters.type));
            }
            return simpleJdbcCall.execute(paramSet);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }
}

