/*
 * Decompiled with CFR 0.152.
 */
package in.bottomhalf.ps.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import in.bottomhalf.ps.model.ApiResponse;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.springframework.stereotype.Service;

@Service
public class HttpRequestService {
    String tokenManagerUri;

    public ApiResponse invoke(Object request) throws Exception {
        HttpURLConnection connection = this.getHttpURLConnection();
        ObjectMapper mapper = new ObjectMapper();
        String requestBody = mapper.writeValueAsString(request);
        try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
            wr.writeBytes(requestBody);
            wr.flush();
        }
        int responseCode = connection.getResponseCode();
        System.out.println("Response Code: " + responseCode);
        ApiResponse apiResponse = null;
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String inputLine;
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            String value = response.toString();
            apiResponse = (ApiResponse)mapper.readValue(value, ApiResponse.class);
            if (apiResponse.getHttpStatusCode() != 200) {
                throw new Exception("Fail to generate token from TokenManager service");
            }
        }
        connection.disconnect();
        return apiResponse;
    }

    public void setHttpUrl(String tokenManagerUri) {
        this.tokenManagerUri = tokenManagerUri;
    }

    private HttpURLConnection getHttpURLConnection() throws IOException {
        URL url = new URL(this.tokenManagerUri);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json");
        return connection;
    }
}

