/*
 * Decompiled with CFR 0.152.
 */
package in.bottomhalf.ps.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import in.bottomhalf.common.models.TokenRequestBody;
import in.bottomhalf.ps.model.ApiResponse;
import in.bottomhalf.ps.model.TokenHubRequestBody;
import in.bottomhalf.ps.service.HttpRequestService;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class TokenHubService {
    @Autowired
    HttpRequestService httpRequestService;
    @Value(value="${bottomhalf.token.url}")
    String tokenManagerUri;
    @Value(value="${bottomhalf.token}")
    String tokenHubKey;
    @Value(value="${bottomhalf.hub.url}")
    String tokenHubUrl;
    @Autowired
    ObjectMapper mapper;

    public ApiResponse generateToken(Object claimObject) throws Exception {
        try {
            HashMap<String, Object> claims = new HashMap<String, Object>();
            TokenRequestBody tokenRequestBody = this.getTokenRequest();
            this.httpRequestService.setHttpUrl(this.tokenManagerUri);
            Class<?> clazz = claimObject.getClass();
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(claimObject);
                claims.put(field.getName(), value);
            }
            tokenRequestBody.setClaims(claims);
            ApiResponse result = this.httpRequestService.invoke(tokenRequestBody);
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public TokenRequestBody getTokenRequest() throws Exception {
        this.httpRequestService.setHttpUrl(this.tokenHubUrl);
        TokenHubRequestBody tokenHubRequestBody = new TokenHubRequestBody();
        tokenHubRequestBody.setAccessToken(this.tokenHubKey);
        ApiResponse response = this.httpRequestService.invoke(tokenHubRequestBody);
        TokenRequestBody requestBody = (TokenRequestBody)this.mapper.convertValue(response.getResponseBody(), TokenRequestBody.class);
        return requestBody;
    }
}

