/*
 * Decompiled with CFR 0.152.
 */
package in.hocg.boot.utils;

import com.google.common.collect.Lists;
import in.hocg.boot.utils.ExceptionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ClassUtils {
    public static <T> T newInstance(String clazzName) {
        return (T)ClassUtils.newInstance(ClassUtils.toClassConfident(clazzName));
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw ExceptionUtils.wrap("\u5b9e\u4f8b\u5316\u5bf9\u8c61\u65f6\u51fa\u73b0\u9519\u8bef,\u8bf7\u5c1d\u8bd5\u7ed9 %s \u6dfb\u52a0\u65e0\u53c2\u7684\u6784\u9020\u65b9\u6cd5", e, clazz.getName());
        }
    }

    public static Class<?> toClassConfident(String name) {
        try {
            return Class.forName(name, false, ClassUtils.getDefaultClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException ex) {
                throw ExceptionUtils.wrap("\u627e\u4e0d\u5230\u6307\u5b9a\u7684class\uff01\u8bf7\u4ec5\u5728\u660e\u786e\u786e\u5b9a\u4f1a\u6709 class \u7684\u65f6\u5019\uff0c\u8c03\u7528\u8be5\u65b9\u6cd5", e, new Object[0]);
            }
        }
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ClassUtils.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    public static List<Field> getAllField(Class<?> clazz) {
        ArrayList result = Lists.newArrayList();
        result.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> superclass = clazz.getSuperclass();
        if (Object.class.equals(superclass)) {
            return result;
        }
        result.addAll(ClassUtils.getAllField(superclass));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getFieldValue(Object fieldObject, Field field, Object def) {
        if (Objects.isNull(fieldObject) || Objects.isNull(field)) {
            return def;
        }
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            Object object = field.get(fieldObject);
            return object;
        }
        catch (IllegalAccessException ignored) {
            Object object = def;
            return object;
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    public static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Optional<Field> getField(Class<?> clazz, String fieldName) {
        Field field;
        block2: {
            field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                Class<?> superclass = clazz.getSuperclass();
                if (Object.class.equals(superclass)) break block2;
                return ClassUtils.getField(clazz, fieldName);
            }
        }
        return Optional.ofNullable(field);
    }

    private ClassUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

