/*
 * Decompiled with CFR 0.152.
 */
package in.hocg.boot.utils;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import in.hocg.boot.utils.ClassUtils;
import in.hocg.boot.utils.annotation.UseDataDictKey;
import in.hocg.boot.utils.dto.DictData;
import in.hocg.boot.utils.enums.DataDictEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class DataDictUtils {
    private static final Map<String, Map<String, Object>> ENUM_CACHE = new HashMap<String, Map<String, Object>>();

    public static List<Class<?>> scanClass(String ... basePackages) {
        return ((Stream)Arrays.stream(basePackages).parallel()).flatMap(s -> ClassUtil.scanPackageBySuper((String)s, DataDictEnum.class).parallelStream()).filter(Class::isEnum).collect(Collectors.toList());
    }

    public static Map<String, Map<String, Object>> scanMaps(String ... basePackages) {
        List<DictData> all = DataDictUtils.scan(basePackages);
        if (ENUM_CACHE.isEmpty()) {
            for (DictData data : all) {
                String key = data.getCode();
                List<DictData.Item> items = data.getItems();
                HashMap<String, String> map = new HashMap<String, String>(items.size());
                for (DictData.Item item : items) {
                    map.put(StrUtil.toString((Object)item.getCode()), item.getTitle());
                }
                ENUM_CACHE.put(key, map);
            }
        }
        return ENUM_CACHE;
    }

    public static List<DictData> scan(String ... basePackages) {
        List<Class<?>> classes = DataDictUtils.scanClass(basePackages);
        ArrayList result = Lists.newArrayList();
        for (Class<?> clazz : classes) {
            DictData dataDict = new DictData();
            String key = clazz.getSimpleName();
            Object title = clazz.getSimpleName() + "\u672a\u4f7f\u7528 @UseDataDictKey";
            boolean enabled = clazz.isAnnotationPresent(Deprecated.class);
            if (clazz.isAnnotationPresent(UseDataDictKey.class)) {
                UseDataDictKey atn = clazz.getAnnotation(UseDataDictKey.class);
                key = atn.value();
                title = atn.description();
            }
            dataDict.setCode(key);
            dataDict.setTitle((String)title);
            dataDict.setEnabled(enabled);
            DataDictEnum[] enums = (DataDictEnum[])clazz.getEnumConstants();
            ArrayList items = Lists.newArrayListWithExpectedSize((int)enums.length);
            for (DataDictEnum itemEnum : enums) {
                boolean isDeprecated = ClassUtils.getField(clazz, ((Enum)((Object)itemEnum)).name()).orElseThrow(IllegalArgumentException::new).isAnnotationPresent(Deprecated.class);
                items.add(new DictData.Item().setTitle(itemEnum.getName()).setEnabled(isDeprecated).setCode(itemEnum.getCode()));
            }
            dataDict.setItems(items);
            result.add(dataDict);
        }
        return result;
    }

    public static List<String> scanSql(List<String> basePackages, Function<DictData, String> formatDataDict, BiFunction<DictData, DictData.Item, String> formatDataDictItem) {
        List<DictData> all = DataDictUtils.scan(basePackages.toArray(new String[0]));
        ArrayList result = Lists.newArrayList();
        for (DictData data : all) {
            result.add(formatDataDict.apply(data));
            for (DictData.Item item : data.getItems()) {
                result.add(formatDataDictItem.apply(data, item));
            }
        }
        return result;
    }

    public static List<String> scanSql(List<String> basePackages) {
        String dataDictSql = "INSERT INTO com_data_dict(`title`, `code`, `remark`, `enabled`) VALUES ('{title}', '{code}', '{remark}', {enabled});";
        String dataDictItemSql = "INSERT INTO com_data_dict_item(`dict_id`, `title`, `code`, `remark`, `enabled`) VALUES (@dict_id, '{title}', '{code}', '{remark}', {enabled});";
        return DataDictUtils.scanSql(basePackages, item -> {
            HashMap vars = Maps.newHashMap();
            vars.put("title", item.getTitle());
            vars.put("code", item.getCode());
            vars.put("remark", item.getTitle());
            vars.put("enabled", item.getEnabled() != false ? "1" : "0");
            return Joiner.on((String)System.lineSeparator()).join((Object)StrUtil.format((CharSequence)"INSERT INTO com_data_dict(`title`, `code`, `remark`, `enabled`) VALUES ('{title}', '{code}', '{remark}', {enabled});", (Map)vars), (Object)"set @dict_id := last_insert_id();", new Object[0]);
        }, (data, item) -> {
            HashMap vars = Maps.newHashMap();
            vars.put("title", item.getTitle());
            vars.put("code", StrUtil.toString((Object)item.getCode()));
            vars.put("remark", StrUtil.format((CharSequence)"{}#{}", (Object[])new Object[]{data.getTitle(), item.getTitle()}));
            vars.put("enabled", item.getEnabled() != false ? "1" : "0");
            return StrUtil.format((CharSequence)"INSERT INTO com_data_dict_item(`dict_id`, `title`, `code`, `remark`, `enabled`) VALUES (@dict_id, '{title}', '{code}', '{remark}', {enabled});", (Map)vars);
        });
    }

    private DataDictUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

