/*
 * Decompiled with CFR 0.152.
 */
package in.hocg.boot.utils;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import in.hocg.boot.utils.function.SupplierThrow;
import in.hocg.boot.utils.function.ThreeConsumerThrow;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogUtils {
    private static final Logger log = LoggerFactory.getLogger(LogUtils.class);

    public static <T> T logSync(SupplierThrow<T> exec, ThreeConsumerThrow<Serializable, LogStatus, String> onComplete) {
        return LogUtils.logSync(exec, null, onComplete);
    }

    public static <T> T logSync(SupplierThrow<T> exec, SupplierThrow<Serializable> onReady, ThreeConsumerThrow<Serializable, LogStatus, String> onComplete) {
        return LogUtils.logAsync(exec, () -> Objects.nonNull(onReady) ? new FutureTask<Serializable>(onReady::get) : null, onComplete);
    }

    public static <T> T logAsync(SupplierThrow<T> exec, SupplierThrow<Future<Serializable>> onReady, ThreeConsumerThrow<Serializable, LogStatus, String> onComplete) {
        T result;
        LogStatus status = LogStatus.Process;
        String resultBody = null;
        Future<Serializable> onFuture = null;
        if (Objects.nonNull(onReady)) {
            try {
                onFuture = onReady.get();
                if (onFuture instanceof FutureTask) {
                    ((FutureTask)onFuture).run();
                }
            }
            catch (Exception e) {
                log.warn("\u8bf7\u6c42\u7cfb\u7edf\u65e5\u5fd7\u8bb0\u5f55(1)\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        try {
            result = exec.get();
            status = LogStatus.Success;
            resultBody = Objects.isNull(result) || ClassUtil.isBasicType(result.getClass()) ? String.valueOf(result) : JSONUtil.toJsonStr(result);
        }
        catch (Exception e) {
            log.warn("\u8bf7\u6c42\u7cfb\u7edf\u4e1a\u52a1\u6267\u884c(2)\u53d1\u751f\u5f02\u5e38: ", (Throwable)e);
            status = LogStatus.Fail;
            resultBody = StrUtil.format((CharSequence)"\u4e1a\u52a1\u6267\u884c\u53d1\u751f\u5f02\u5e38: [{}]", (Object[])new Object[]{e.getMessage()});
            throw new RuntimeException(e);
        }
        finally {
            if (Objects.nonNull(onFuture) && Objects.nonNull(onComplete)) {
                try {
                    onComplete.accept(onFuture.get(5L, TimeUnit.SECONDS), status, resultBody);
                }
                catch (Exception e) {
                    log.warn("\u8bf7\u6c42\u7cfb\u7edf\u65e5\u5fd7\u8bb0\u5f55(3)\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
            }
            log.debug("\u65e5\u5fd7\u8bb0\u5f55\u6267\u884c\u5b8c\u6210");
        }
        return result;
    }

    private LogUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum LogStatus {
        Process,
        Fail,
        Success;

    }
}

