/*
 * Decompiled with CFR 0.152.
 */
package in.hocg.boot.utils;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class Rules<K> {
    private final Map<Function<K, Boolean>, Supplier<?>> rules = Maps.newHashMap();
    private Supplier<?> defaultRule = UnsupportedOperationException::new;

    public static <K> Rules<K> create() {
        return new Rules<K>();
    }

    public Rules<K> rule(Function<K, Boolean> match, Supplier<?> fs) {
        this.rules.put(match, fs);
        return this;
    }

    public Rules<K> rule(K type, Supplier<?> fs) {
        return this.rule((K)this.keyFunction(type), fs);
    }

    public Rules<K> defRule(Supplier<?> fs) {
        this.defaultRule = fs;
        return this;
    }

    public <R> Optional<R> of(K args) {
        Object o;
        Supplier<?> rule = this.defaultRule;
        for (Map.Entry<Function<K, Boolean>, Supplier<?>> entry : this.rules.entrySet()) {
            if (!entry.getKey().apply(args).booleanValue()) continue;
            rule = entry.getValue();
            break;
        }
        if ((o = rule.get()) instanceof RuntimeException) {
            throw (RuntimeException)o;
        }
        return Optional.ofNullable(o);
    }

    private Function<K, Boolean> keyFunction(K type) {
        return k -> Objects.equals(k, type);
    }

    public static <P> Supplier<P> Runnable(Runnable fun) {
        return () -> {
            fun.run();
            return null;
        };
    }

    public static <P> Supplier<P> Supplier(Supplier<P> fun) {
        return fun;
    }
}

