/*
 * Decompiled with CFR 0.152.
 */
package in.hocg.boot.utils.enums;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ArrayUtil;
import in.hocg.boot.utils.LangUtils;
import java.io.Serializable;
import java.util.Optional;

public interface ICode {
    public Serializable getCode();

    default public String getCodeStr() {
        return Convert.toStr((Object)this.getCode());
    }

    default public Integer getCodeInt() {
        return Convert.toInt((Object)this.getCode());
    }

    default public boolean eq(Serializable val) {
        if (val instanceof Enum) {
            return this.equals(val);
        }
        return LangUtils.equal(this.getCode(), val);
    }

    default public boolean anyMatch(ICode ... codes) {
        if (ArrayUtil.isEmpty((Object[])codes)) {
            return false;
        }
        return ArrayUtil.contains((Object[])codes, (Object)this);
    }

    default public boolean anyMatch(Serializable ... codes) {
        if (ArrayUtil.isEmpty((Object[])codes)) {
            return false;
        }
        return ArrayUtil.contains((Object[])codes, (Object)this.getCode());
    }

    public static <T extends ICode> T ofThrow(Serializable code, Class<T> enumClass) {
        Optional<T> enumOpl = ICode.of(code, enumClass);
        if (enumOpl.isPresent()) {
            return (T)((ICode)enumOpl.get());
        }
        throw new IllegalArgumentException("\u672a\u627e\u5230\u5339\u914d\u7684\u7c7b\u578b");
    }

    public static <T extends ICode> Optional<T> of(Serializable code, Class<T> enumClass) {
        ICode[] constants;
        for (ICode value : constants = (ICode[])enumClass.getEnumConstants()) {
            if (!value.eq(code)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static <T extends Enum<T>> Optional<T> ofName(String name, Class<T> enumClass) {
        return Optional.of(Enum.valueOf(enumClass, name));
    }
}

