/*
 * Decompiled with CFR 0.152.
 */
package in.hocg.boot.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileMode;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Lists;
import in.hocg.boot.utils.ext.MultiList;
import in.hocg.boot.utils.function.ConsumerThrow;
import in.hocg.boot.utils.lambda.SFunction;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class LangUtils {
    private static final Map<Class<?>, List<Field>> CLASS_FIELD_CACHE = new ConcurrentHashMap();

    public static boolean isPresent(String name) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean equals(Integer s1, Integer s2) {
        if (s1 == null || s2 == null) {
            return Objects.equals(s1, s2);
        }
        return s1.compareTo(s2) == 0;
    }

    public static boolean equals(Long s1, Long s2) {
        if (s1 == null || s2 == null) {
            return Objects.equals(s1, s2);
        }
        return s1.compareTo(s2) == 0;
    }

    public static boolean equals(Boolean s1, Boolean s2) {
        if (s1 == null || s2 == null) {
            return Objects.equals(s1, s2);
        }
        return s1.equals(s2);
    }

    public static boolean equals(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return Objects.equals(s1, s2);
        }
        return s1.equals(s2);
    }

    public static boolean equal(Object v1, Object v2) {
        if (Objects.isNull(v1)) {
            return Objects.isNull(v2);
        }
        if (v1 instanceof String) {
            return v1.equals(Convert.toStr((Object)v2));
        }
        if (v1 instanceof Integer) {
            return v1.equals(Convert.toInt((Object)v2));
        }
        if (v1 instanceof Character) {
            return v1.equals(Convert.toChar((Object)v2));
        }
        if (v1 instanceof Double) {
            return v1.equals(Convert.toDouble((Object)v2));
        }
        if (v1 instanceof Short) {
            return v1.equals(Convert.toShort((Object)v2));
        }
        if (v1 instanceof Long) {
            return v1.equals(Convert.toLong((Object)v2));
        }
        if (v1 instanceof Boolean) {
            return v1.equals(Convert.toBool((Object)v2));
        }
        if (v1 instanceof Byte) {
            return v1.equals(Convert.toByte((Object)v2));
        }
        return ObjectUtil.equal((Object)v1, (Object)v2);
    }

    public static <K, V> Map<K, V> toMap(Collection<V> values, Function<? super V, K> keyFunction) {
        HashMap<K, V> result = new HashMap<K, V>();
        for (V val : values) {
            K key = keyFunction.apply(val);
            result.put(key, val);
        }
        return result;
    }

    public static <K, V, Z> Map<K, Z> toMap(Collection<V> values, Function<? super V, K> keyFunction, Function<? super V, Z> valueFunction) {
        HashMap<K, Z> result = new HashMap<K, Z>();
        for (V val : values) {
            K key = keyFunction.apply(val);
            Z value = valueFunction.apply(val);
            result.put(key, value);
        }
        return result;
    }

    public static Object getFieldValue(Object fieldObject, Field field, Object def) {
        if (Objects.isNull(fieldObject) || Objects.isNull(field)) {
            return def;
        }
        try {
            field.setAccessible(true);
            return field.get(fieldObject);
        }
        catch (IllegalAccessException ignored) {
            return def;
        }
    }

    public static <T> T getObjectValue(Object fieldObject, Field field, Object def) {
        return (T)LangUtils.getFieldValue(fieldObject, field, def);
    }

    public static void setFieldValue(Object fieldObject, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(fieldObject, value);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static <K, V> V computeIfAbsent(Map<K, V> concurrentHashMap, K key, Function<? super K, ? extends V> mappingFunction) {
        V v = concurrentHashMap.get(key);
        if (v != null) {
            return v;
        }
        return concurrentHashMap.computeIfAbsent((K)key, mappingFunction);
    }

    public static List<Field> getAllField(Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            return Collections.emptyList();
        }
        return LangUtils.computeIfAbsent(CLASS_FIELD_CACHE, clazz, k -> {
            Field[] fields = k.getDeclaredFields();
            ArrayList<Field> superFields = new ArrayList<Field>();
            for (Class currentClass = k.getSuperclass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                Field[] declaredFields = currentClass.getDeclaredFields();
                Collections.addAll(superFields, declaredFields);
            }
            Map<String, Field> fieldMap = LangUtils.excludeOverrideSuperField(fields, superFields);
            return fieldMap.values().stream().filter(f -> !Modifier.isStatic(f.getModifiers())).filter(f -> !Modifier.isTransient(f.getModifiers())).collect(Collectors.toList());
        });
    }

    public static Map<String, Field> excludeOverrideSuperField(Field[] fields, List<Field> superFieldList) {
        Map fieldMap = Stream.of(fields).collect(Collectors.toMap(Field::getName, Function.identity(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        superFieldList.stream().filter(field -> !fieldMap.containsKey(field.getName())).forEach(f -> fieldMap.put(f.getName(), f));
        return fieldMap;
    }

    public static boolean isBaseType(Class<?> clazz) {
        return clazz.equals(Integer.class) || clazz.equals(Byte.class) || clazz.equals(Long.class) || clazz.equals(Double.class) || clazz.equals(Float.class) || clazz.equals(Character.class) || clazz.equals(Short.class) || clazz.equals(Boolean.class);
    }

    public static String toString(Object object) {
        if (Objects.isNull(object)) {
            return null;
        }
        if (object instanceof Integer) {
            return Integer.toString((Integer)object);
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public static List<String> toList(Object[] arr) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object i : arr) {
            result.add(LangUtils.toString(i));
        }
        return result;
    }

    public static <V, R> List<R> toList(Iterable<V> values, Function<? super V, R> keyFunction) {
        return LangUtils.toList(values, false, keyFunction);
    }

    public static <V, R> List<R> toList(Iterable<V> values, boolean filterNull, Function<? super V, R> fn) {
        ArrayList result = Lists.newArrayList();
        for (V val : values) {
            R keyValue = fn.apply(val);
            if (filterNull && Objects.isNull(keyValue)) continue;
            result.add(keyValue);
        }
        return result;
    }

    public static <V> MultiList<V> toMultiList(Iterable<V> values, SFunction<V, ?> ... fnList) {
        return LangUtils.toMultiList(values, false, fnList);
    }

    public static <V> MultiList<V> toMultiList(Iterable<V> values, boolean filterNull, SFunction<V, ?> ... fnList) {
        MultiList<V> result = new MultiList<V>();
        if (ArrayUtil.isEmpty((Object[])fnList)) {
            return result;
        }
        for (V val : values) {
            for (SFunction<V, ?> fn : fnList) {
                Object keyValue = fn.apply(val);
                if (filterNull && Objects.isNull(keyValue)) continue;
                result.add(fn, keyValue);
            }
        }
        return result;
    }

    public static <R, T> List<R> removeIfExits(Collection<R> all, Collection<T> sub, BiFunction<R, T, Boolean> biFunction) {
        ArrayList result = Lists.newArrayList(all);
        if (result.isEmpty()) {
            return result;
        }
        Iterator iterator = result.iterator();
        block0: while (iterator.hasNext()) {
            Object r = iterator.next();
            for (T t : sub) {
                if (!biFunction.apply(r, t).booleanValue()) continue;
                iterator.remove();
                continue block0;
            }
        }
        return result;
    }

    public static <R, T> List<R> getMixed(Collection<R> l1, Collection<T> l2, BiFunction<R, T, Boolean> biFunction) {
        ArrayList result = Lists.newArrayList();
        block0: for (R t1 : l1) {
            for (T t2 : l2) {
                if (!biFunction.apply(t1, t2).booleanValue()) continue;
                result.add(t1);
                continue block0;
            }
        }
        return result;
    }

    public static <T> T getOrDefault(T v, T def) {
        if (Objects.isNull(v)) {
            return def;
        }
        return v;
    }

    public static <K, V> Optional<V> callIfNotNull(K v, Function<K, V> func) {
        if (Objects.nonNull(v)) {
            return Optional.ofNullable(func.apply(v));
        }
        return Optional.empty();
    }

    public static <K> void runIfNotNull(K v, ConsumerThrow<K> func) {
        if (Objects.nonNull(v)) {
            func.accept(v);
        }
    }

    public static <T> void setIfNotNull(T v, Consumer<T> consumer) {
        if (Objects.nonNull(v)) {
            consumer.accept(v);
        }
    }

    public static <R, P> List<R> groupCallback(Collection<P> allIds, Function<Collection<P>, Collection<R>> queryFunction, int len) {
        if (CollectionUtil.isEmpty(allIds)) {
            return Collections.emptyList();
        }
        ArrayList all = Lists.newArrayList(allIds);
        ArrayList result = Lists.newArrayList();
        int startIndex = 0;
        int maxLength = all.size();
        while (startIndex < maxLength) {
            int toIndex = Math.min(startIndex + len, maxLength);
            List ids = all.subList(startIndex, toIndex);
            result.addAll(queryFunction.apply(ids));
            startIndex = toIndex;
        }
        return result;
    }

    public static <K, T> Map<K, List<T>> toGroup(List<T> list, Function<? super T, ? extends K> keyFunction) {
        return list.parallelStream().collect(Collectors.groupingBy(keyFunction));
    }

    public static void proxy(String host, String port) {
        host = StrUtil.nullToDefault((CharSequence)host, (String)"127.0.0.1");
        port = StrUtil.nullToDefault((CharSequence)port, (String)"7890");
        System.setProperty("http.proxyHost", host);
        System.setProperty("http.proxyPort", port);
        System.setProperty("https.proxyHost", host);
        System.setProperty("https.proxyPort", port);
    }

    public static Path modifyMD5(Path path) {
        Path path2;
        block6: {
            RandomAccessFile file = FileUtil.createRandomAccessFile((Path)path, (FileMode)FileMode.rw);
            try {
                file.seek(file.length());
                file.writeBytes(RandomUtil.randomString((int)5));
                file.close();
                path2 = path;
                if (Collections.singletonList(file).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(file).get(0) != null) {
                    file.close();
                }
                throw throwable;
            }
            file.close();
        }
        return path2;
    }

    public static String extract(String regex, String content) {
        Matcher matcher = Pattern.compile(regex).matcher(content);
        String result = "";
        if (matcher.find()) {
            result = matcher.group();
        }
        return result;
    }

    public static <T> T lastElement(T[] elements) {
        if (ArrayUtil.isEmpty((Object[])elements)) {
            return null;
        }
        return elements[elements.length - 1];
    }

    public static Pair<String, Map<String, String>> getParams(String url) {
        String urlStr = url;
        HashMap params = new HashMap();
        if (StrUtil.contains((CharSequence)url, (CharSequence)"?")) {
            int index = StrUtil.indexOf((CharSequence)url, (char)'?');
            urlStr = StrUtil.sub((CharSequence)url, (int)0, (int)index);
            Arrays.stream(StrUtil.blankToDefault((CharSequence)StrUtil.sub((CharSequence)url, (int)(index + 1), (int)url.length()), (String)"").split("&")).map(s -> s.split("=", 2)).forEach(keyValue -> params.put(keyValue[0], keyValue[1]));
        }
        return new Pair((Object)urlStr, params);
    }

    public static <K, V> Map<V, K> reverse(Map<K, V> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public static <E> List<E> getDuplicateElements(List<E> list) {
        return list.stream().collect(Collectors.toMap((? super T e) -> e, (? super T e) -> 1, Integer::sum)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private LangUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

