/*
 * Decompiled with CFR 0.152.
 */
package in.hocg.boot.utils.db;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbUtil;
import cn.hutool.db.Entity;
import in.hocg.boot.utils.LangUtils;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.sql.DataSource;

public final class DbUtils {
    public static boolean check(DataSource dataSource) {
        return DbUtil.use((DataSource)dataSource).execute("select 1", new Object[0]) > 0;
    }

    public static boolean existTable(DataSource dataSource, String tableName) {
        DbUtil.use((DataSource)dataSource).execute("desc :tableName", new Object[]{tableName});
        return false;
    }

    public static LocalDateTime asLocalDateTime(String str) {
        return LocalDateTimeUtil.parse((CharSequence)StrUtil.nullToEmpty((CharSequence)str));
    }

    public static LocalDateTime getLocalDateTime(Entity entity, String columnName) {
        Object value = entity.get((Object)columnName);
        if (Objects.isNull(value)) {
            return null;
        }
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).toLocalDateTime();
        }
        if (value instanceof String) {
            String str = (String)value;
            return LangUtils.callIfNotNull(str, s -> {
                int length = StrUtil.length((CharSequence)s);
                if (length == 23) {
                    return LocalDateTime.parse(s, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
                }
                if (length == 22) {
                    return LocalDateTime.parse(s, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SS"));
                }
                return null;
            }).orElse(null);
        }
        throw new UnsupportedOperationException();
    }

    private DbUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

