/*
 * Decompiled with CFR 0.152.
 */
package in.hocg.boot.utils.db.schema;

import cn.hutool.db.ds.DSFactory;
import cn.hutool.db.meta.Column;
import cn.hutool.db.meta.JdbcType;
import cn.hutool.db.meta.Table;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.PolyJDBCBuilder;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.dialect.DialectRegistry;
import org.polyjdbc.core.dialect.MsSqlDialect;
import org.polyjdbc.core.dialect.OracleDialect;
import org.polyjdbc.core.exception.SchemaInspectionException;
import org.polyjdbc.core.schema.model.LongAttributeBuilder;
import org.polyjdbc.core.schema.model.RelationBuilder;
import org.polyjdbc.core.schema.model.Schema;

public class SchemaUtils {
    private Connection connection;
    private Dialect dialect = DialectRegistry.MYSQL.getDialect();

    public void createIfNeeded(Table table) {
        if (this.relationExists(table)) {
            return;
        }
        DataSource dataSource = DSFactory.get();
        PolyJDBC polyjdbc = PolyJDBCBuilder.polyJDBC((Dialect)this.dialect).connectingToDataSource(dataSource).build();
        Schema schema = new Schema(this.dialect);
        String tableName = table.getTableName();
        RelationBuilder relationBuilder = schema.addRelation(tableName);
        relationBuilder.withAttribute().primaryKey("idx_pk").using(table.getPkNames().toArray(new String[0])).and();
        for (Column column : table.getColumns()) {
            this.handleRelation(relationBuilder, column);
        }
        relationBuilder.build();
        polyjdbc.schemaManager().create(schema);
    }

    private void handleRelation(RelationBuilder relationBuilder, Column column) {
        LongAttributeBuilder attributeBuilder;
        String columnName = column.getName();
        JdbcType typeEnum = column.getTypeEnum();
        boolean nullable = column.isNullable();
        int size = column.getSize();
        Object defaultValue = null;
        if (Lists.newArrayList((Object[])new JdbcType[]{JdbcType.BIGINT}).contains(typeEnum)) {
            attributeBuilder = relationBuilder.withAttribute().longAttr(columnName).withIntegerPrecision(size);
        } else if (Lists.newArrayList((Object[])new JdbcType[]{JdbcType.VARBINARY}).contains(typeEnum)) {
            attributeBuilder = relationBuilder.withAttribute().string(columnName).withMaxLength(size);
        } else if (Lists.newArrayList((Object[])new JdbcType[]{JdbcType.DATE}).contains(typeEnum)) {
            attributeBuilder = relationBuilder.withAttribute().date(columnName);
        } else if (Lists.newArrayList((Object[])new JdbcType[]{JdbcType.TIMESTAMP}).contains(typeEnum)) {
            attributeBuilder = relationBuilder.withAttribute().timestamp(columnName);
        } else if (Lists.newArrayList((Object[])new JdbcType[]{JdbcType.BOOLEAN}).contains(typeEnum)) {
            attributeBuilder = relationBuilder.withAttribute().booleanAttr(columnName);
        } else if (Lists.newArrayList((Object[])new JdbcType[]{JdbcType.INTEGER}).contains(typeEnum)) {
            attributeBuilder = relationBuilder.withAttribute().integer(columnName).withIntegerPrecision(size);
        } else if (Lists.newArrayList((Object[])new JdbcType[]{JdbcType.CHAR}).contains(typeEnum)) {
            attributeBuilder = relationBuilder.withAttribute().character(columnName);
        } else if (Lists.newArrayList((Object[])new JdbcType[]{JdbcType.FLOAT}).contains(typeEnum)) {
            attributeBuilder = relationBuilder.withAttribute().floatAttr(columnName);
        } else if (Lists.newArrayList((Object[])new JdbcType[]{JdbcType.LONGNVARCHAR}).contains(typeEnum)) {
            attributeBuilder = relationBuilder.withAttribute().text(columnName);
        } else if (Lists.newArrayList((Object[])new JdbcType[]{JdbcType.NUMERIC}).contains(typeEnum)) {
            attributeBuilder = relationBuilder.withAttribute().number(columnName).withDecimalPrecision(size);
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b");
        }
        if (!nullable) {
            attributeBuilder.notNull();
        }
        attributeBuilder.withDefaultValue(defaultValue);
    }

    public String getSchema() {
        try {
            return this.connection.getSchema();
        }
        catch (SQLException e) {
            return "";
        }
    }

    public boolean relationExists(Table table) {
        return this.relationExists(table.getTableName(), this.getSchema());
    }

    public boolean relationExists(String name, String schemaName) {
        try {
            String tableSchemaName;
            DatabaseMetaData metadata = this.connection.getMetaData();
            String catalog = this.connection.getCatalog();
            ResultSet resultSet = metadata.getTables(catalog, this.convertCase(schemaName, metadata), this.convertCase(name, metadata), new String[]{"TABLE"});
            if (schemaName != null) {
                return resultSet.next();
            }
            do {
                if (resultSet.next()) continue;
                return false;
            } while ((tableSchemaName = resultSet.getString("TABLE_SCHEM")) != null && !tableSchemaName.equalsIgnoreCase("public") && !tableSchemaName.contains("") && (!(this.dialect instanceof MsSqlDialect) || !tableSchemaName.equalsIgnoreCase("dbo")) && (!(this.dialect instanceof OracleDialect) || !tableSchemaName.equalsIgnoreCase("system")));
            return true;
        }
        catch (SQLException var8) {
            throw new SchemaInspectionException("RELATION_LOOKUP_ERROR", "Failed to obtain tables metadata when checking table " + name, (Throwable)var8);
        }
    }

    private String convertCase(String identifier, DatabaseMetaData metadata) throws SQLException {
        if (identifier != null && !identifier.isEmpty()) {
            if (metadata.storesLowerCaseIdentifiers()) {
                return identifier.toLowerCase();
            }
            return metadata.storesUpperCaseIdentifiers() ? identifier.toUpperCase() : identifier;
        }
        return identifier;
    }
}

