/*
 * Decompiled with CFR 0.152.
 */
package in.hocg.boot.utils.lambda;

import cn.hutool.core.util.StrUtil;
import in.hocg.boot.utils.lambda.SFunction;
import in.hocg.boot.utils.lambda.SerializationUtils;
import in.hocg.boot.utils.utils.ClassUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SerializedLambda
implements Serializable {
    private static final long serialVersionUID = 8025925345765570181L;
    private Class<?> capturingClass;
    private String functionalInterfaceClass;
    private String functionalInterfaceMethodName;
    private String functionalInterfaceMethodSignature;
    private String implClass;
    private String implMethodName;
    private String implMethodSignature;
    private int implMethodKind;
    private String instantiatedMethodType;
    private Object[] capturedArgs;
    private static final Pattern INSTANTIATED_METHOD_TYPE = Pattern.compile("\\(L(?<instantiatedMethodType>[\\S&&[^;)]]+);\\)L[\\S]+;");

    public static SerializedLambda resolve(SFunction<?, ?> lambda) {
        SerializedLambda serializedLambda;
        if (!lambda.getClass().isSynthetic()) {
            throw new RuntimeException("\u8be5\u65b9\u6cd5\u4ec5\u80fd\u4f20\u5165 lambda \u8868\u8fbe\u5f0f\u4ea7\u751f\u7684\u5408\u6210\u7c7b");
        }
        ObjectInputStream objIn = new ObjectInputStream(new ByteArrayInputStream(Objects.requireNonNull(SerializationUtils.serialize(lambda)))){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                Class<?> clazz = super.resolveClass(objectStreamClass);
                return clazz == java.lang.invoke.SerializedLambda.class ? SerializedLambda.class : clazz;
            }
        };
        try {
            serializedLambda = (SerializedLambda)objIn.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    objIn.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException("This is impossible to happen", e);
            }
        }
        objIn.close();
        return serializedLambda;
    }

    public String getFunctionalInterfaceClassName() {
        return this.normalizedName(this.functionalInterfaceClass);
    }

    public static Class<?> toClassConfident(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u6307\u5b9a\u7684class\uff01\u8bf7\u4ec5\u5728\u660e\u786e\u786e\u5b9a\u4f1a\u6709 class \u7684\u65f6\u5019\uff0c\u8c03\u7528\u8be5\u65b9\u6cd5", e);
        }
    }

    public String getImplClassName() {
        return this.normalizedName(this.implClass);
    }

    public String getImplMethodName() {
        return this.implMethodName;
    }

    public Class<?> getImplClass() {
        return ClassUtils.toClassConfident(this.getImplClassName());
    }

    public Class getInstantiatedType() {
        String instantiatedTypeName = this.normalizedName(this.instantiatedMethodType.substring(2, this.instantiatedMethodType.indexOf(59)));
        return ClassUtils.toClassConfident(instantiatedTypeName);
    }

    public String toString() {
        String interfaceName = this.getFunctionalInterfaceClassName();
        String implName = this.getImplClassName();
        return String.format("%s -> %s::%s", interfaceName.substring(interfaceName.lastIndexOf(46) + 1), implName.substring(implName.lastIndexOf(46) + 1), this.implMethodName);
    }

    private String normalizedName(String name) {
        return name.replace('/', '.');
    }

    public Class getInstantiatedMethodType() {
        Matcher matcher = INSTANTIATED_METHOD_TYPE.matcher(this.instantiatedMethodType);
        if (matcher.find()) {
            return ClassUtils.toClassConfident(this.normalizedName(matcher.group("instantiatedMethodType")));
        }
        throw new RuntimeException(StrUtil.format((CharSequence)"\u65e0\u6cd5\u4ece {} \u89e3\u6790\u8c03\u7528\u5b9e\u4f8b", (Object[])new Object[]{this.instantiatedMethodType}));
    }
}

