/*
 * Decompiled with CFR 0.152.
 */
package in.hocg.boot.utils.struct.result;

import cn.hutool.core.util.StrUtil;
import in.hocg.boot.utils.struct.result.Result;

public class ExceptionResult<T>
extends Result<T> {
    private Integer status;
    private Long timestamp;
    private String exception;

    public static <T> ExceptionResult<T> fail(Integer status, String message) {
        return ExceptionResult.fail(status, message, null);
    }

    public static <T> ExceptionResult<T> fail(Integer status, Exception e) {
        return ExceptionResult.fail(status, StrUtil.emptyToDefault((CharSequence)e.getMessage(), (String)"\u7cfb\u7edf\u7e41\u5fd9"), e.getClass().getName());
    }

    public static <T> ExceptionResult<T> fail(Integer status, String message, String exception) {
        ExceptionResult<T> result = new ExceptionResult<T>();
        result.setSuccess(false);
        result.setStatus(status);
        result.setException(exception);
        result.setMessage(message);
        result.setTimestamp(System.currentTimeMillis());
        return result;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public String getException() {
        return this.exception;
    }

    public ExceptionResult<T> setStatus(Integer status) {
        this.status = status;
        return this;
    }

    public ExceptionResult<T> setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public ExceptionResult<T> setException(String exception) {
        this.exception = exception;
        return this;
    }

    public String toString() {
        return "ExceptionResult(status=" + this.getStatus() + ", timestamp=" + this.getTimestamp() + ", exception=" + this.getException() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExceptionResult)) {
            return false;
        }
        ExceptionResult other = (ExceptionResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Long this$timestamp = this.getTimestamp();
        Long other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$exception = this.getException();
        String other$exception = other.getException();
        return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExceptionResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Long $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        return result;
    }
}

