/*
 * Decompiled with CFR 0.152.
 */
package in.hocg.boot.utils.utils;

import cn.hutool.core.util.StrUtil;
import java.util.Objects;

public final class SensitiveUtils {
    public static String custom(String str, int prefixNoMaskSize, int suffixNoMaskSize, String mask) {
        if (StrUtil.isEmpty((CharSequence)str)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            if (i < prefixNoMaskSize) {
                sb.append(str.charAt(i));
                continue;
            }
            if (i > n - suffixNoMaskSize - 1) {
                sb.append(str.charAt(i));
                continue;
            }
            sb.append(mask);
        }
        return sb.toString();
    }

    public static String chineseName(String str) {
        if (StrUtil.isEmpty((CharSequence)str)) {
            return null;
        }
        return SensitiveUtils.custom(str, 0, 1, "*");
    }

    public static String idCardNum(String str) {
        return SensitiveUtils.custom(str, 6, 4, "*");
    }

    public static String telephone(String str) {
        return SensitiveUtils.custom(str, 0, 4, "*");
    }

    public static String mobilePhone(String str) {
        return SensitiveUtils.custom(str, 3, 4, "*");
    }

    public static String address(String str) {
        return SensitiveUtils.custom(str, 6, 0, "*");
    }

    public static String email(String str) {
        if (StrUtil.isEmpty((CharSequence)str)) {
            return null;
        }
        int index = StrUtil.indexOf((CharSequence)str, (char)'@');
        if (index <= 1) {
            return str;
        }
        String preEmail = SensitiveUtils.custom(str.substring(0, index), 1, 0, "*");
        return preEmail + str.substring(index);
    }

    public static String bankCard(String str) {
        return SensitiveUtils.custom(str, 6, 4, "*");
    }

    public static String password(String str) {
        if (StrUtil.isEmpty((CharSequence)str)) {
            return null;
        }
        return "******";
    }

    public static String key(String key) {
        if (StrUtil.isEmpty((CharSequence)key)) {
            return null;
        }
        int viewLength = 6;
        StringBuilder tmpKey = new StringBuilder(Objects.requireNonNull(SensitiveUtils.custom(key, 0, 3, "*")));
        if (tmpKey.length() > viewLength) {
            return tmpKey.substring(tmpKey.length() - viewLength);
        }
        if (tmpKey.length() < viewLength) {
            int buffLength = viewLength - tmpKey.length();
            for (int i = 0; i < buffLength; ++i) {
                tmpKey.insert(0, "*");
            }
            return tmpKey.toString();
        }
        return tmpKey.toString();
    }

    private SensitiveUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

