/*
 * Decompiled with CFR 0.152.
 */
package in.hocg.boot.utils.utils;

import cn.hutool.core.lang.Assert;
import java.util.Collection;
import java.util.Map;

public final class ValidUtils {
    public static <T> T notNull(T object, String errorMsgTemplate, Object ... params) {
        return (T)Assert.notNull(object, (String)errorMsgTemplate, (Object[])params);
    }

    public static <T> T notNull(T object) {
        return (T)Assert.notNull(object);
    }

    public static void isNull(Object object, String errorMsgTemplate, Object ... params) {
        Assert.isNull((Object)object, (String)errorMsgTemplate, (Object[])params);
    }

    public static void isNull(Object object) {
        Assert.isNull((Object)object);
    }

    public static void isTrue(boolean expression, String errorMsgTemplate, Object ... params) {
        Assert.isTrue((boolean)expression, (String)errorMsgTemplate, (Object[])params);
    }

    public static void isTrue(boolean expression) {
        Assert.isTrue((boolean)expression);
    }

    public static void isFalse(boolean expression, String errorMsgTemplate, Object ... params) {
        Assert.isFalse((boolean)expression, (String)errorMsgTemplate, (Object[])params);
    }

    public static void isFalse(boolean expression) {
        Assert.isFalse((boolean)expression);
    }

    public static <T extends CharSequence> T notEmpty(T text, String errorMsgTemplate, Object ... params) {
        return (T)Assert.notEmpty(text, (String)errorMsgTemplate, (Object[])params);
    }

    public static <T extends CharSequence> T notEmpty(T text) {
        return (T)Assert.notEmpty(text);
    }

    public static <T extends CharSequence> T notBlank(T text, String errorMsgTemplate, Object ... params) {
        return (T)Assert.notBlank(text, (String)errorMsgTemplate, (Object[])params);
    }

    public static <T extends CharSequence> T notBlank(T text) {
        return (T)Assert.notBlank(text);
    }

    public static String notContain(String textToSearch, String substring, String errorMsgTemplate, Object ... params) {
        return Assert.notContain((String)textToSearch, (String)substring, (String)errorMsgTemplate, (Object[])params);
    }

    public static String notContain(String textToSearch, String substring) {
        return Assert.notContain((String)textToSearch, (String)substring);
    }

    public static Object[] notEmpty(Object[] array, String errorMsgTemplate, Object ... params) {
        return Assert.notEmpty((Object[])array, (String)errorMsgTemplate, (Object[])new Object[]{errorMsgTemplate, params});
    }

    public static Object[] notEmpty(Object[] array) {
        return Assert.notEmpty((Object[])array);
    }

    public static <T> T[] noNullElements(T[] array, String errorMsgTemplate, Object ... params) {
        return Assert.noNullElements((Object[])array, (String)errorMsgTemplate, (Object[])params);
    }

    public static <T> T[] noNullElements(T[] array) {
        return Assert.noNullElements((Object[])array);
    }

    public static <T> Collection<T> notEmpty(Collection<T> collection, String errorMsgTemplate, Object ... params) {
        return Assert.notEmpty(collection, (String)errorMsgTemplate, (Object[])params);
    }

    public static <T> Collection<T> notEmpty(Collection<T> collection) {
        return Assert.notEmpty(collection);
    }

    public static <K, V> Map<K, V> notEmpty(Map<K, V> map, String errorMsgTemplate, Object ... params) {
        return Assert.notEmpty(map, (String)errorMsgTemplate, (Object[])params);
    }

    public static <K, V> Map<K, V> notEmpty(Map<K, V> map) {
        return Assert.notEmpty(map);
    }

    public static <T> T isInstanceOf(Class<?> type, T obj, String errorMsgTemplate, Object ... params) {
        return (T)Assert.isInstanceOf(type, obj, (String)errorMsgTemplate, (Object[])params);
    }

    public static <T> T isInstanceOf(Class<?> type, T obj) {
        return (T)Assert.isInstanceOf(type, obj);
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, String errorMsgTemplate, Object ... params) {
        Assert.isAssignable(superType, subType, (String)errorMsgTemplate, (Object[])params);
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) {
        Assert.isAssignable(superType, subType);
    }

    public static void state(boolean expression, String errorMsgTemplate, Object ... params) {
        Assert.state((boolean)expression, (String)errorMsgTemplate, (Object[])params);
    }

    public static void state(boolean expression) {
        Assert.state((boolean)expression);
    }

    public static int checkIndex(int index, int size, String errorMsgTemplate, Object ... params) {
        return Assert.checkIndex((int)index, (int)size, (String)errorMsgTemplate, (Object[])params);
    }

    public static int checkIndex(int index, int size) {
        return Assert.checkIndex((int)index, (int)size);
    }

    public static Number checkBetween(Number value, Number min, Number max) {
        return Assert.checkBetween((Number)value, (Number)min, (Number)max);
    }

    public static double checkBetween(double value, double min, double max) {
        return Assert.checkBetween((double)value, (double)min, (double)max);
    }

    public static long checkBetween(long value, long min, long max) {
        return Assert.checkBetween((long)value, (long)min, (long)max);
    }

    public static int checkBetween(int value, int min, int max) {
        return Assert.checkBetween((int)value, (int)min, (int)max);
    }

    public static void fail(String message) {
        throw new IllegalArgumentException(message);
    }

    public static void fail(Exception e) {
        ValidUtils.fail(e.getMessage());
    }

    private ValidUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

