/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import jlibs.core.lang.ImpossibleException;

public class BeanUtil {
    public static final String GET = "get";
    public static final String IS = "is";
    public static final String SET = "set";

    public static String getMethodSuffix(String property) {
        switch (property.length()) {
            case 0: {
                throw new IllegalArgumentException("invalid property name: " + property);
            }
            case 1: {
                return property.toUpperCase(Locale.ENGLISH);
            }
        }
        char char0 = property.charAt(0);
        boolean upper0 = Character.isUpperCase(char0);
        char char1 = property.charAt(1);
        boolean upper1 = Character.isUpperCase(char1);
        if (upper0 && upper1) {
            return property;
        }
        if (!upper0 && !upper1) {
            return Character.toUpperCase(char0) + property.substring(1);
        }
        if (!upper0 && upper1) {
            return property;
        }
        throw new IllegalArgumentException("invalid property name: " + property);
    }

    public static String getPropertyName(String methodName) {
        String suffix;
        if (methodName.startsWith(GET) || methodName.startsWith(SET)) {
            suffix = methodName.substring(3);
        } else if (methodName.startsWith(IS)) {
            suffix = methodName.substring(2);
        } else {
            throw new IllegalArgumentException("invalid method name: " + methodName);
        }
        switch (suffix.length()) {
            case 0: {
                throw new IllegalArgumentException("invalid method name: " + methodName);
            }
            case 1: {
                return suffix.toLowerCase(Locale.ENGLISH);
            }
        }
        char char0 = suffix.charAt(0);
        boolean upper0 = Character.isUpperCase(char0);
        char char1 = suffix.charAt(1);
        boolean upper1 = Character.isUpperCase(char1);
        if (upper0 && upper1) {
            return suffix;
        }
        if (upper0 && !upper1) {
            return Character.toLowerCase(char0) + suffix.substring(1);
        }
        if (!upper0 && upper1) {
            return suffix;
        }
        throw new IllegalArgumentException("invalid method name: " + methodName);
    }

    public static Method getGetterMethod(Class<?> beanClass, String property) {
        try {
            return beanClass.getMethod(GET + BeanUtil.getMethodSuffix(property), new Class[0]);
        }
        catch (NoSuchMethodException ex1) {
            try {
                return beanClass.getMethod(IS + BeanUtil.getMethodSuffix(property), new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                return null;
            }
        }
    }

    public static Method getGetterMethod(Class<?> beanClass, String property, Class propertyType) {
        try {
            try {
                if (propertyType == Boolean.TYPE) {
                    return beanClass.getMethod(IS + BeanUtil.getMethodSuffix(property), new Class[0]);
                }
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
            return beanClass.getMethod(GET + BeanUtil.getMethodSuffix(property), new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Method getSetterMethod(Class<?> beanClass, String property) {
        Method getter = BeanUtil.getGetterMethod(beanClass, property);
        if (getter == null) {
            return null;
        }
        return BeanUtil.getSetterMethod(beanClass, property, getter.getReturnType());
    }

    public static Method getSetterMethod(Class<?> beanClass, String property, Class propertyType) {
        try {
            return beanClass.getMethod(SET + BeanUtil.getMethodSuffix(property), propertyType);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static Class getPropertyType(Class<?> beanClass, String property) {
        Method getter = BeanUtil.getGetterMethod(beanClass, property);
        if (getter == null) {
            return null;
        }
        return getter.getReturnType();
    }

    public static <T> T getProperty(Object bean, String property) throws InvocationTargetException {
        try {
            return (T)BeanUtil.getGetterMethod(bean.getClass(), property).invoke(bean, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new ImpossibleException(ex);
        }
    }

    public static void setProperty(Object bean, String property, Object value) throws InvocationTargetException {
        try {
            BeanUtil.getSetterMethod(bean.getClass(), property).invoke(bean, value);
        }
        catch (IllegalAccessException ex) {
            throw new ImpossibleException(ex);
        }
    }
}

