/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.net;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class SSLUtil {
    private static KeyStore[] defaultKeyStore;
    private static KeyStore[] defaultTrustStore;
    public static final TrustManager[] DUMMY_TRUST_MANAGERS;
    private static SSLContext defaultContext;

    public static boolean isClientHello(byte firstByte) {
        return firstByte == 128 || firstByte == 22;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate[] getX509CertificateChain(String host, int port) throws GeneralSecurityException, IOException {
        final X509Certificate[][] result = new X509Certificate[1][];
        X509TrustManager savingTM = new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
                result[0] = chain;
            }
        };
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{savingTM}, null);
        SSLSocketFactory factory = sslContext.getSocketFactory();
        SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
        try {
            socket.startHandshake();
        }
        finally {
            socket.close();
        }
        return result[0];
    }

    public static KeyStore newKeyStore(String type, String file, char[] password) throws SSLException {
        try {
            KeyStore ks = KeyStore.getInstance(type == null ? KeyStore.getDefaultType() : type);
            ks.load(file != null ? new FileInputStream(file) : null, (char[])(password != null ? password : null));
            return ks;
        }
        catch (Exception ex) {
            throw new SSLException(ex);
        }
    }

    public static String getKeyStoreType() {
        return System.getProperty("javax.net.ssl.keyStoreType", "JKS");
    }

    public static String getKeyStoreLocation() {
        return System.getProperty("javax.net.ssl.keyStore");
    }

    public static char[] getKeyStorePassword() {
        String password = System.getProperty("javax.net.ssl.keyStorePassword");
        return password != null ? password.toCharArray() : null;
    }

    public static KeyStore defaultKeyStore() throws SSLException {
        if (defaultKeyStore == null) {
            String location = SSLUtil.getKeyStoreLocation();
            defaultKeyStore = location != null ? new KeyStore[]{SSLUtil.newKeyStore(SSLUtil.getKeyStoreType(), location, SSLUtil.getKeyStorePassword())} : new KeyStore[]{null};
        }
        return defaultKeyStore[0];
    }

    public static String getTrustStoreType() {
        return System.getProperty("javax.net.ssl.trustStoreType", "JKS");
    }

    public static String getTrustStoreLocation() {
        return System.getProperty("javax.net.ssl.trustStore");
    }

    public static char[] getTrustStorePassword() {
        String password = System.getProperty("javax.net.ssl.trustStorePassword");
        return password != null ? password.toCharArray() : null;
    }

    public static KeyStore defaultTrustStore() throws SSLException {
        if (defaultTrustStore == null) {
            String location = SSLUtil.getTrustStoreLocation();
            defaultTrustStore = location != null ? new KeyStore[]{SSLUtil.newKeyStore(SSLUtil.getTrustStoreType(), location, SSLUtil.getTrustStorePassword())} : new KeyStore[]{null};
        }
        return defaultTrustStore[0];
    }

    public static SSLContext newContext(KeyStore keyStore, char[] keyStorePassword, String keyAlias, KeyStore trustStore) throws SSLException, GeneralSecurityException {
        TrustManager[] tm;
        SSLContext sslContext = SSLContext.getInstance("TLS");
        if (trustStore == null) {
            tm = DUMMY_TRUST_MANAGERS;
        } else {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            tm = tmf.getTrustManagers();
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, keyStorePassword);
        KeyManager[] km = kmf.getKeyManagers();
        if (keyAlias != null) {
            for (int i = 0; i < km.length; ++i) {
                if (km[i] instanceof X509ExtendedKeyManager) {
                    km[i] = new ExtendedAliasKeyManager(km[i], keyAlias);
                    continue;
                }
                if (!(km[i] instanceof X509KeyManager)) continue;
                km[i] = new AliasKeyManager(km[i], keyAlias);
            }
        }
        sslContext.init(km, tm, null);
        return sslContext;
    }

    public static SSLContext defaultContext() throws SSLException, GeneralSecurityException {
        if (defaultContext == null) {
            defaultContext = SSLUtil.newContext(SSLUtil.defaultKeyStore(), SSLUtil.getKeyStorePassword(), null, SSLUtil.defaultTrustStore());
        }
        return defaultContext;
    }

    private static String chooseAlias(X509KeyManager mgr, String serverKeyAlias, String keyType) {
        PrivateKey key = mgr.getPrivateKey(serverKeyAlias);
        if (key != null) {
            if (key.getAlgorithm().equals(keyType)) {
                return serverKeyAlias;
            }
            return null;
        }
        return null;
    }

    static {
        DUMMY_TRUST_MANAGERS = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }
        }};
    }

    private static final class AliasKeyManager
    implements X509KeyManager {
        private X509KeyManager delegate;
        private String serverKeyAlias;

        public AliasKeyManager(KeyManager mgr, String keyAlias) {
            this.delegate = (X509KeyManager)mgr;
            this.serverKeyAlias = keyAlias;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.delegate.chooseClientAlias(keyType, issuers, socket);
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return SSLUtil.chooseAlias(this.delegate, this.serverKeyAlias, keyType);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.delegate.getCertificateChain(alias);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.delegate.getClientAliases(keyType, issuers);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.delegate.getServerAliases(keyType, issuers);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.delegate.getPrivateKey(alias);
        }
    }

    private static final class ExtendedAliasKeyManager
    extends X509ExtendedKeyManager {
        private X509ExtendedKeyManager delegate;
        private String serverKeyAlias;

        public ExtendedAliasKeyManager(KeyManager mgr, String keyAlias) {
            this.delegate = (X509ExtendedKeyManager)mgr;
            this.serverKeyAlias = keyAlias;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.delegate.chooseClientAlias(keyType, issuers, socket);
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return SSLUtil.chooseAlias(this.delegate, this.serverKeyAlias, keyType);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.delegate.getCertificateChain(alias);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.delegate.getClientAliases(keyType, issuers);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.delegate.getServerAliases(keyType, issuers);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.delegate.getPrivateKey(alias);
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            return this.delegate.chooseEngineClientAlias(keyType, issuers, engine);
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            return SSLUtil.chooseAlias(this.delegate, this.serverKeyAlias, keyType);
        }
    }
}

