/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.graph;

import java.lang.reflect.InvocationTargetException;
import jlibs.core.graph.Visitor;

public class VisitorUtil {
    static final String FORMAT = "${package}.${class}Impl";

    private static Class findGeneratedClass(Class clazz) throws ClassNotFoundException {
        String qname = FORMAT.replace("${package}", clazz.getPackage() != null ? clazz.getPackage().getName() : "").replace("${class}", clazz.getSimpleName());
        if (qname.startsWith(".")) {
            qname = qname.substring(1);
        }
        return clazz.getClassLoader().loadClass(qname);
    }

    public static <E, R> Visitor<E, R> createVisitor(Object delegate) {
        try {
            Class implClass = VisitorUtil.findGeneratedClass(delegate.getClass());
            return (Visitor)implClass.getConstructor(delegate.getClass()).newInstance(delegate);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <E, R> Visitor<E, R> createVisitor(Class clazz) {
        try {
            return (Visitor)VisitorUtil.findGeneratedClass(clazz).newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }
}

