/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.dom;

import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import jlibs.xml.dom.DOMUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMNamespaceContext
implements NamespaceContext {
    private Node node;

    public DOMNamespaceContext(Node node) {
        this.node = node;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix is null");
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        Attr attr = DOMUtil.findNamespaceDeclarationForPrefix(this.node, prefix);
        if (attr != null) {
            return attr.getNodeValue();
        }
        if ("".equals(prefix)) {
            return "";
        }
        return null;
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespaceURI is null");
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return "xmlns";
        }
        Attr attr = DOMUtil.findNamespaceDeclarationForURI(this.node, namespaceURI);
        if (attr != null) {
            return attr.getLocalName();
        }
        if ("".equals(namespaceURI)) {
            return "";
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        return new Iterator(this.node);
    }

    public static class Iterator
    implements java.util.Iterator<String> {
        private Node node;
        private Set<String> prefixes = new HashSet<String>();
        private int attrIndex = -1;
        private Attr attr;

        public Iterator(Node node) {
            this.node = node;
            this.findNext();
        }

        private void findNext() {
            do {
                NamedNodeMap attrs;
                if ((attrs = this.node.getAttributes()) != null) {
                    int length = attrs.getLength();
                    ++this.attrIndex;
                    while (this.attrIndex < length) {
                        Attr attr = (Attr)attrs.item(this.attrIndex);
                        if (DOMUtil.isNamespaceDeclaration(attr) && !this.prefixes.contains(attr.getLocalName())) {
                            return;
                        }
                        ++this.attrIndex;
                    }
                }
                this.node = this.node.getParentNode();
                this.attrIndex = -1;
            } while (this.node != null);
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        @Override
        public String next() {
            if (this.hasNext()) {
                this.attr = (Attr)this.node.getAttributes().item(this.attrIndex);
                this.prefixes.add(this.attr.getLocalName());
                this.findNext();
                return this.attr.getLocalName();
            }
            throw new NoSuchElementException();
        }

        public String getNamespaceURI() {
            return this.attr.getNamespaceURI();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

