/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.dom;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.BitSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import jlibs.core.lang.Util;
import jlibs.xml.dom.DOMLocator;
import jlibs.xml.dom.DOMNamespaceContext;
import jlibs.xml.sax.SAXDelegate;
import jlibs.xml.xsl.TransformerUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DOMUtil {
    public static DocumentBuilder newDocumentBuilder(boolean nsAware, boolean validating) throws ParserConfigurationException {
        return DOMUtil.newDocumentBuilder(nsAware, validating, false, false);
    }

    public static DocumentBuilder newDocumentBuilder(boolean nsAware, boolean validating, boolean coalescing, boolean ignoreComments) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(nsAware);
        factory.setValidating(validating);
        factory.setCoalescing(coalescing);
        factory.setIgnoringComments(ignoreComments);
        return factory.newDocumentBuilder();
    }

    public static boolean isNamespaceDeclaration(Attr attr) {
        return "http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI());
    }

    public static Attr findNamespaceDeclarationForPrefix(Node node, String prefix) {
        while (node != null) {
            NamedNodeMap attrs = node.getAttributes();
            if (attrs != null) {
                for (int i = attrs.getLength() - 1; i >= 0; --i) {
                    Attr attr = (Attr)attrs.item(i);
                    if (!DOMUtil.isNamespaceDeclaration(attr) || !prefix.equals(attr.getLocalName())) continue;
                    return attr;
                }
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static Attr findNamespaceDeclarationForURI(Node node, String uri) {
        while (node != null) {
            NamedNodeMap attrs = node.getAttributes();
            if (attrs != null) {
                for (int i = attrs.getLength() - 1; i >= 0; --i) {
                    Attr attr = (Attr)attrs.item(i);
                    if (!DOMUtil.isNamespaceDeclaration(attr) || !uri.equals(attr.getNodeValue())) continue;
                    return attr;
                }
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static boolean equals(Node node1, Node node2) {
        if (node1 == node2) {
            return true;
        }
        Node n1 = node1;
        Node n2 = node2;
        while (DOMUtil.shallowEquals(n1, n2)) {
            if (n1 == null) {
                assert (n2 == null);
                return true;
            }
            Node n1Child = null;
            if (n1.getNodeType() == 9 || n1.getNodeType() == 1) {
                n1Child = n1.getFirstChild();
            }
            Node n2Child = null;
            if (n2.getNodeType() == 9 || n2.getNodeType() == 1) {
                n2Child = n2.getFirstChild();
            }
            if (!DOMUtil.shallowEquals(n1Child, n2Child)) {
                return false;
            }
            if (n1Child == null) {
                Node n2Sibling;
                Node n1Sibling;
                assert (n2Child == null);
                if (n1 == node1 && n2 == node2) {
                    return true;
                }
                while (true) {
                    if (!DOMUtil.shallowEquals(n1Sibling = n1.getNextSibling(), n2Sibling = n2.getNextSibling())) {
                        return false;
                    }
                    if (n1Sibling != null) break;
                    assert (n2Sibling == null);
                    Node n1Parent = n1.getParentNode();
                    Node n2Parent = n2.getParentNode();
                    if (n1Parent == null && n2Parent == null) {
                        return true;
                    }
                    if (n1Parent == node1 && n2Parent == node2) {
                        return true;
                    }
                    assert (n1Parent != null && n2Parent != null);
                    n1 = n1Parent;
                    n2 = n2Parent;
                }
                assert (n2Sibling != null);
                n1 = n1Sibling;
                n2 = n2Sibling;
                continue;
            }
            n1 = n1Child;
            n2 = n2Child;
        }
        return false;
    }

    private static boolean shallowEquals(Node n1, Node n2) {
        int type2;
        if (n1 == n2) {
            return true;
        }
        if (n1 == null || n2 == null) {
            return false;
        }
        int type1 = n1.getNodeType();
        if (type1 == 4) {
            type1 = 3;
        }
        if ((type2 = n2.getNodeType()) == 4) {
            type2 = 3;
        }
        if (type1 != type2) {
            return false;
        }
        switch (type1) {
            case 7: {
                ProcessingInstruction pi1 = (ProcessingInstruction)n1;
                ProcessingInstruction pi2 = (ProcessingInstruction)n2;
                if (pi1.getTarget().equals(pi1.getTarget()) && pi1.getData().equals(pi2.getData())) break;
                return false;
            }
            case 8: {
                Comment comment1 = (Comment)n1;
                Comment comment2 = (Comment)n2;
                if (comment1.getData().equals(comment2.getData())) break;
                return false;
            }
            case 1: {
                int i;
                String namespaceURI2;
                Element element1 = (Element)n1;
                Element element2 = (Element)n2;
                String namespaceURI1 = element1.getNamespaceURI();
                if (namespaceURI1 == null) {
                    namespaceURI1 = "";
                }
                if ((namespaceURI2 = element2.getNamespaceURI()) == null) {
                    namespaceURI2 = "";
                }
                if (!namespaceURI1.equals(namespaceURI2) || !element1.getLocalName().equals(element2.getLocalName())) {
                    return false;
                }
                NamedNodeMap attrs1 = element1.getAttributes();
                NamedNodeMap attrs2 = element2.getAttributes();
                BitSet bitSet = new BitSet();
                for (i = 0; i < attrs1.getLength(); ++i) {
                    Attr attr1 = (Attr)attrs1.item(i);
                    if (DOMUtil.isNamespaceDeclaration(attr1)) continue;
                    namespaceURI1 = attr1.getNamespaceURI();
                    if (namespaceURI1 == null) {
                        namespaceURI1 = "";
                    }
                    String localName1 = attr1.getLocalName();
                    String value1 = attr1.getNodeValue();
                    int found = -1;
                    for (int j = 0; j < attrs2.getLength(); ++j) {
                        Attr attr2 = (Attr)attrs2.item(j);
                        namespaceURI2 = attr2.getNamespaceURI();
                        if (namespaceURI2 == null) {
                            namespaceURI2 = "";
                        }
                        String localName2 = attr2.getLocalName();
                        if (!namespaceURI1.equals(namespaceURI2) || !localName1.equals(localName2)) continue;
                        String value2 = attr2.getNodeValue();
                        if (!value1.equals(value2)) {
                            return false;
                        }
                        found = j;
                        break;
                    }
                    if (found == -1) {
                        return false;
                    }
                    bitSet.set(found);
                }
                for (i = 0; i < attrs2.getLength(); ++i) {
                    Attr attr2;
                    if (bitSet.get(i) || DOMUtil.isNamespaceDeclaration(attr2 = (Attr)attrs2.item(i))) continue;
                    return false;
                }
                break;
            }
            case 2: {
                String namespaceURI2;
                Attr attr1 = (Attr)n1;
                Attr attr2 = (Attr)n2;
                String namespaceURI1 = attr1.getNamespaceURI();
                if (namespaceURI1 == null) {
                    namespaceURI1 = "";
                }
                if ((namespaceURI2 = attr2.getNamespaceURI()) == null) {
                    namespaceURI2 = "";
                }
                if (namespaceURI1.equals(namespaceURI2) && attr1.getLocalName().equals(attr2.getLocalName()) && attr1.getNodeValue().equals(attr2.getNodeValue())) break;
                return false;
            }
            case 3: {
                if (n1.getNodeValue().equals(n2.getNodeValue())) break;
                return false;
            }
        }
        return true;
    }

    public static String toString(Node node) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DOMUtil.serialize(node, new PrintStream(bout, true));
        return bout.toString();
    }

    public static void serialize(Node node, PrintStream out) {
        switch (node.getNodeType()) {
            case 2: {
                out.print(node.getNodeName());
                out.print("=\"");
                out.print(node.getNodeValue().replace("\"", "&quot;"));
                out.print("\"");
                break;
            }
            case 13: {
                out.print("xmlns:");
                out.print(node.getLocalName());
                out.print("=\"");
                out.print(node.getNodeValue().replace("\"", "&quot;"));
                out.print("\"");
                break;
            }
            case 3: 
            case 4: {
                out.print(node.getTextContent());
                break;
            }
            case 8: {
                out.print("<!--");
                out.print(node.getNodeValue());
                out.print("-->");
                break;
            }
            case 7: {
                out.print("<?");
                out.print(node.getNodeName());
                out.print(' ');
                out.print(node.getNodeValue());
                out.print("?>");
                break;
            }
            default: {
                try {
                    Transformer transformer = TransformerUtil.newTransformer(null, true, 0, null);
                    transformer.transform(new DOMSource(node), new StreamResult(out));
                    break;
                }
                catch (TransformerException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    public static void toSAX(Node root, SAXDelegate handler) throws SAXException {
        DOMLocator locator = new DOMLocator();
        switch (root.getNodeType()) {
            case 9: {
                break;
            }
            case 1: {
                handler.setDocumentLocator(locator);
                handler.startDocument();
                if (root.getParentNode() == null) break;
                DOMNamespaceContext.Iterator iter = new DOMNamespaceContext.Iterator(root.getParentNode());
                while (iter.hasNext()) {
                    handler.startPrefixMapping(iter.next(), iter.getNamespaceURI());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Node must be Document or Element");
            }
        }
        Node node = root;
        AttributesImpl attrs = new AttributesImpl();
        block18: while (node != null) {
            Node attr;
            int i;
            NamedNodeMap nodeAttrs;
            locator.node = node;
            switch (node.getNodeType()) {
                case 9: {
                    handler.setDocumentLocator(locator);
                    handler.startDocument();
                    break;
                }
                case 10: {
                    DocumentType docType = (DocumentType)node;
                    handler.startDTD(docType.getName(), docType.getPublicId(), docType.getSystemId());
                    break;
                }
                case 1: {
                    attrs.clear();
                    nodeAttrs = node.getAttributes();
                    if (nodeAttrs != null) {
                        for (i = nodeAttrs.getLength() - 1; i >= 0; --i) {
                            attr = nodeAttrs.item(i);
                            if ("xmlns".equals(attr.getNodeName())) {
                                handler.startPrefixMapping("", attr.getNodeValue());
                                continue;
                            }
                            if ("xmlns".equals(attr.getPrefix())) {
                                handler.startPrefixMapping(attr.getLocalName(), attr.getNodeValue());
                                continue;
                            }
                            attrs.addAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getNodeName(), "CDATA", attr.getNodeValue());
                        }
                    }
                    handler.startElement(node.getNamespaceURI(), node.getLocalName(), node.getNodeName(), attrs);
                    break;
                }
                case 3: {
                    char[] chars = node.getNodeValue().toCharArray();
                    handler.characters(chars, 0, chars.length);
                    break;
                }
                case 4: {
                    char[] chars = node.getNodeValue().toCharArray();
                    handler.startCDATA();
                    handler.characters(chars, 0, chars.length);
                    handler.endCDATA();
                    break;
                }
                case 7: {
                    ProcessingInstruction pi = (ProcessingInstruction)node;
                    handler.processingInstruction(pi.getTarget(), pi.getData());
                    break;
                }
                case 8: {
                    char[] chars = node.getNodeValue().toCharArray();
                    handler.comment(chars, 0, chars.length);
                }
            }
            NodeList children = node.getChildNodes();
            if (children != null && children.getLength() > 0) {
                node = children.item(0);
                continue;
            }
            while (true) {
                locator.node = node;
                switch (node.getNodeType()) {
                    case 1: {
                        handler.endElement(node.getNamespaceURI(), node.getLocalName(), node.getNodeName());
                        nodeAttrs = node.getAttributes();
                        if (nodeAttrs == null) break;
                        for (i = nodeAttrs.getLength() - 1; i >= 0; --i) {
                            attr = nodeAttrs.item(i);
                            if ("xmlns".equals(attr.getNodeName())) {
                                handler.endPrefixMapping("");
                                continue;
                            }
                            if (!"xmlns".equals(attr.getPrefix())) continue;
                            handler.endPrefixMapping(attr.getLocalName());
                        }
                        break;
                    }
                    case 10: {
                        handler.endDTD();
                    }
                }
                if (node == root) {
                    if (root.getNodeType() == 1 && root.getParentNode() != null) {
                        DOMNamespaceContext.Iterator iter = new DOMNamespaceContext.Iterator(root.getParentNode());
                        while (iter.hasNext()) {
                            handler.endPrefixMapping(iter.next());
                        }
                    }
                    handler.endDocument();
                    return;
                }
                if (node.getNextSibling() != null) {
                    node = node.getNextSibling();
                    continue block18;
                }
                node = node.getParentNode();
            }
        }
    }

    public static int getPosition(Element elem) {
        Node node;
        int pos = 1;
        NodeList list = elem.getParentNode().getChildNodes();
        for (int i = 0; i < list.getLength() && (node = list.item(i)) != elem; ++i) {
            if (!(node instanceof Element) || !Util.equals((Object)node.getNamespaceURI(), (Object)elem.getNamespaceURI()) || !node.getLocalName().equals(elem.getLocalName())) continue;
            ++pos;
        }
        return pos;
    }

    public static void main(String[] args) throws Exception {
        String file = "/Volumes/Backup/projects/office/trunk/fountainhead/gateway/testsuites/newregression/messagevalidation/resources/anothergsearch.wsdl";
        Document doc = DOMUtil.newDocumentBuilder(true, false, false, false).parse(file);
        SAXDelegate delegate = new SAXDelegate();
        TransformerHandler handler = TransformerUtil.newTransformerHandler(null, true, 0, null);
        delegate.setHandler(handler);
        DOMResult result = new DOMResult();
        handler.setResult(result);
        Node node = doc;
        node = doc.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "binding").item(0);
        DOMUtil.toSAX(node, delegate);
        node = result.getNode();
        TransformerUtil.newTransformer(null, true, 0, null).transform(new DOMSource(node), new StreamResult(System.out));
    }
}

