/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import jlibs.core.lang.ImpossibleException;
import jlibs.xml.sax.SAXUtil;
import jlibs.xml.sax.dog.XPathResults;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.Literal;
import jlibs.xml.sax.dog.expr.func.FunctionCall;
import jlibs.xml.sax.dog.expr.nodset.LocationExpression;
import jlibs.xml.sax.dog.expr.nodset.PathExpression;
import jlibs.xml.sax.dog.path.LocationPath;
import jlibs.xml.sax.dog.path.PositionalPredicate;
import jlibs.xml.sax.dog.path.Step;
import jlibs.xml.sax.dog.sniff.Event;
import jlibs.xml.sax.dog.sniff.SAXHandler;
import jlibs.xml.sax.dog.sniff.XPathParser;
import jlibs.xml.stream.STAXXMLReader;
import org.jaxen.saxpath.SAXPathException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public final class XMLDog {
    public final NamespaceContext nsContext;
    public final XPathVariableResolver variableResolver;
    public final XPathFunctionResolver functionResolver;
    private final XPathParser parser;
    private final List<Expression> expressions = new ArrayList<Expression>();
    private final List<Expression> docExpressions = new ArrayList<Expression>();
    private final List<Expression> globalExpressions = new ArrayList<Expression>();

    public XMLDog(NamespaceContext nsContext) {
        this(nsContext, null, null);
    }

    public XMLDog(NamespaceContext nsContext, XPathVariableResolver variableResolver, XPathFunctionResolver functionResolver) {
        this.nsContext = nsContext;
        this.variableResolver = variableResolver;
        this.functionResolver = functionResolver;
        this.parser = new XPathParser(nsContext, variableResolver, functionResolver);
    }

    public boolean isAllowDefaultPrefixMapping() {
        return this.parser.isAllowDefaultPrefixMapping();
    }

    public void setAllowDefaultPrefixMapping(boolean allow) {
        this.parser.setAllowDefaultPrefixMapping(allow);
    }

    public Expression addXPath(String xpath) throws SAXPathException {
        Expression compiledExpr = this.parser.parse(xpath, true);
        compiledExpr.setXPath(xpath);
        this.addXPath(compiledExpr);
        return compiledExpr;
    }

    public Expression addForEach(String forEach, String xpath) throws SAXPathException {
        Expression forEachExpr = this.parser.parse(forEach, true);
        LocationPath union = new LocationPath(2, 0);
        if (forEachExpr instanceof LocationExpression) {
            union.addToContext(((LocationExpression)forEachExpr).locationPath);
        } else {
            union.addToContext(((PathExpression)forEachExpr).union);
        }
        Expression relativeExpr = this.parser.parse(xpath, false);
        PathExpression compiledExpr = new PathExpression(union, relativeExpr, true);
        compiledExpr.setXPath("#for-each " + forEach + " #eval " + xpath);
        this.addXPath(compiledExpr);
        return compiledExpr;
    }

    private void addXPath(Expression compiledExpr) throws SAXPathException {
        this.expressions.add(compiledExpr);
        switch (compiledExpr.scope()) {
            case 1: {
                this.searchDocExpressions(compiledExpr, compiledExpr);
                break;
            }
            case 0: {
                assert (compiledExpr instanceof Literal);
                this.globalExpressions.add(compiledExpr);
                break;
            }
            default: {
                throw new ImpossibleException("scope of " + compiledExpr.getXPath() + " can't be" + compiledExpr.scope());
            }
        }
    }

    private void searchDocExpressions(Expression userExpr, Expression expr) {
        if (expr.scope() == 1) {
            expr.id = this.docExpressions.size();
            this.docExpressions.add(expr);
            if (expr != userExpr) {
                expr.storeResult = true;
            }
        }
        if (expr instanceof LocationExpression) {
            for (Step step : ((LocationExpression)expr).locationPath.steps) {
                Expression predicate = step.predicateSet.getPredicate();
                if (predicate == null) continue;
                if (predicate.scope() != 0) {
                    this.searchDocExpressions(userExpr, predicate);
                }
                PositionalPredicate positionPredicate = step.predicateSet.headPositionalPredicate;
                while (positionPredicate != null) {
                    if (positionPredicate.predicate.scope() != 0) {
                        this.searchDocExpressions(userExpr, positionPredicate.predicate);
                    }
                    positionPredicate = positionPredicate.next;
                }
            }
        } else if (expr instanceof FunctionCall) {
            FunctionCall functionCall = (FunctionCall)expr;
            for (Expression member : functionCall.members) {
                if (member.scope() == 0) continue;
                this.searchDocExpressions(userExpr, member);
            }
        } else if (expr instanceof PathExpression) {
            PathExpression pathExpr = (PathExpression)expr;
            if (pathExpr.union.predicateSet.getPredicate() != null) {
                this.searchDocExpressions(userExpr, pathExpr.union.predicateSet.getPredicate());
            }
            for (Expression context : pathExpr.contexts) {
                this.searchDocExpressions(userExpr, context);
            }
            this.searchDocExpressions(userExpr, pathExpr.relativeExpression);
        }
    }

    public Iterable<Expression> getXPaths() {
        return this.expressions;
    }

    public int getDocumentXPathsCount() {
        return this.docExpressions.size();
    }

    public Event createEvent() {
        return new Event(this.nsContext, this.globalExpressions, this.docExpressions, 7 + this.parser.constraints.size(), this.parser.langInterested);
    }

    public void sniff(Event event, InputSource source, boolean useSTAX) throws XPathException {
        try {
            Object reader = useSTAX ? new STAXXMLReader() : SAXUtil.newSAXFactory((boolean)true, (boolean)false, (boolean)false).newSAXParser().getXMLReader();
            this.sniff(event, source, (XMLReader)reader);
        }
        catch (Exception ex) {
            throw new XPathException(ex);
        }
    }

    public void sniff(Event event, InputSource source, XMLReader reader) throws XPathException {
        block4: {
            try {
                SAXHandler handler = event.getSAXHandler();
                reader.setContentHandler(handler);
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            }
            catch (Exception ex) {
                throw new XPathException(ex);
            }
            try {
                reader.parse(source);
            }
            catch (Exception ex) {
                if (ex == Event.STOP_PARSING) break block4;
                throw new XPathException(ex);
            }
        }
    }

    public XPathResults sniff(InputSource source, boolean useSTAX) throws XPathException {
        Event event = this.createEvent();
        XPathResults results = new XPathResults(event);
        event.setListener(results);
        this.sniff(event, source, useSTAX);
        return results;
    }

    public void sniff(Event event, InputSource source) throws XPathException {
        this.sniff(event, source, false);
    }

    public XPathResults sniff(InputSource source) throws XPathException {
        Event event = this.createEvent();
        XPathResults results = new XPathResults(event);
        event.setListener(results);
        this.sniff(event, source);
        return results;
    }
}

