/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.expr.func;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import jlibs.xml.sax.dog.DataType;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.func.Function;
import jlibs.xml.sax.dog.expr.func.FunctionCall;
import jlibs.xml.sax.dog.expr.func.PeekingFunction;
import jlibs.xml.sax.dog.path.LocationPath;

public class Functions {
    public static final ArithmeticFunction ADD;
    public static final ArithmeticFunction SUBSTRACT;
    public static final ArithmeticFunction MULTIPLY;
    public static final ArithmeticFunction DIV;
    public static final ArithmeticFunction MOD;
    public static final Function CEIL;
    public static final Function FLOOR;
    public static final Function ROUND;
    public static final Function LENGTH;
    public static final Function STARTS_WITH;
    public static final Function ENDS_WITH;
    public static final Function CONTAINS;
    public static final Function CONCAT;
    public static final Function LANGUAGE_MATCH;
    public static final Function TRANSLATE;
    public static final Function NORMALIZE_SPACE;
    public static final Function SUBSTRING;
    public static final ChangeCase UPPER_CASE;
    public static final ChangeCase LOWER_CASE;
    public static final Function AND;
    public static final Function OR;
    public static final Function NOT;
    public static final Function NUMBER_EQUALS_NUMBER;
    public static final Function STRING_EQUALS_STRING;
    public static final Function STRINGS_EQUALS_STRING;
    public static final Function NUMBERS_EQUALS_NUMBER;
    public static final Function STRINGS_EQUALS_STRINGS;
    public static final Function EQUALS;
    public static final Function NOT_EQUALS;
    public static final Function GREATER_THAN;
    public static final Function GREATER_THAN_EQUAL;
    public static final Function LESS_THAN;
    public static final Function LESS_THAN_EQUAL;
    public static final Map<String, Function> library;

    public static Expression typeCast(Object current, DataType expected) {
        if (current instanceof Expression) {
            Expression expr = (Expression)current;
            DataType exprResultType = expr.resultType;
            if (exprResultType == expected || expected == DataType.STRINGS) {
                return expr;
            }
            if (expected == DataType.NUMBERS) {
                if (exprResultType == DataType.NUMBER) {
                    return expr;
                }
                expected = DataType.NUMBER;
            }
            if (expected == DataType.PRIMITIVE) {
                switch (exprResultType) {
                    case STRING: 
                    case BOOLEAN: 
                    case NUMBER: {
                        return expr;
                    }
                }
                expected = DataType.STRING;
            }
            FunctionCall function = new FunctionCall(new TypeCast(expected));
            function.addValidMember(expr, 0);
            return function.simplify();
        }
        return ((LocationPath)current).typeCast(expected).simplify();
    }

    static {
        Function[] functions;
        ADD = new ArithmeticFunction("+"){

            @Override
            public Object evaluate(Object ... args) {
                return (Double)args[0] + (Double)args[1];
            }
        };
        SUBSTRACT = new ArithmeticFunction("-"){

            @Override
            public Object evaluate(Object ... args) {
                return (Double)args[0] - (Double)args[1];
            }
        };
        MULTIPLY = new ArithmeticFunction("*"){

            @Override
            public Object evaluate(Object ... args) {
                return (Double)args[0] * (Double)args[1];
            }
        };
        DIV = new ArithmeticFunction("div"){

            @Override
            public Object evaluate(Object ... args) {
                return (Double)args[0] / (Double)args[1];
            }
        };
        MOD = new ArithmeticFunction("mod"){

            @Override
            public Object evaluate(Object ... args) {
                return (Double)args[0] % (Double)args[1];
            }
        };
        CEIL = new Function("ceiling", DataType.NUMBER, false, new DataType[]{DataType.NUMBER, DataType.NUMBER}){

            @Override
            public Object evaluate(Object ... args) {
                Double d = (Double)args[0];
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    return d;
                }
                return Math.ceil(d);
            }
        };
        FLOOR = new Function("floor", DataType.NUMBER, false, new DataType[]{DataType.NUMBER, DataType.NUMBER}){

            @Override
            public Object evaluate(Object ... args) {
                Double d = (Double)args[0];
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    return d;
                }
                return Math.floor(d);
            }
        };
        ROUND = new Function("round", DataType.NUMBER, false, new DataType[]{DataType.NUMBER, DataType.NUMBER}){

            @Override
            public Object evaluate(Object ... args) {
                Double d = (Double)args[0];
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    return d;
                }
                return (double)Math.round(d);
            }
        };
        LENGTH = new Function("string-length", DataType.NUMBER, false, new DataType[]{DataType.STRING}){

            @Override
            public Object evaluate(Object ... args) {
                String str = (String)args[0];
                return (double)str.codePointCount(0, str.length());
            }
        };
        STARTS_WITH = new Function("starts-with", DataType.BOOLEAN, false, new DataType[]{DataType.STRING, DataType.STRING}){

            @Override
            public Object evaluate(Object ... args) {
                return ((String)args[0]).startsWith((String)args[1]);
            }
        };
        ENDS_WITH = new Function("ends-with", DataType.BOOLEAN, false, new DataType[]{DataType.STRING, DataType.STRING}){

            @Override
            public Object evaluate(Object ... args) {
                return ((String)args[0]).endsWith((String)args[1]);
            }
        };
        CONTAINS = new Function("contains", DataType.BOOLEAN, false, new DataType[]{DataType.STRING, DataType.STRING}){

            @Override
            public Object evaluate(Object ... args) {
                return ((String)args[0]).contains((String)args[1]);
            }
        };
        CONCAT = new Function("concat", DataType.STRING, true, new DataType[]{DataType.STRING, DataType.STRING}){

            @Override
            public Object evaluate(Object ... args) {
                StringBuilder buff = new StringBuilder();
                for (Object arg : args) {
                    buff.append(arg);
                }
                return buff.toString();
            }
        };
        LANGUAGE_MATCH = new Function("language-match", DataType.BOOLEAN, false, new DataType[]{DataType.STRING, DataType.STRING}){

            @Override
            public Object evaluate(Object ... args) {
                String sublang = (String)args[0];
                String lang = (String)args[1];
                if (sublang.equalsIgnoreCase(lang)) {
                    return true;
                }
                int len = lang.length();
                return sublang.length() > len && sublang.charAt(len) == '-' && sublang.substring(0, len).equalsIgnoreCase(lang);
            }
        };
        TRANSLATE = new Function("translate", DataType.STRING, false, new DataType[]{DataType.STRING, DataType.STRING, DataType.STRING}){

            @Override
            public Object evaluate(Object ... args) {
                return this.translate((String)args[0], (String)args[1], (String)args[2]);
            }

            public String translate(String input, String from, String to) {
                HashMap<String, String> characterMap = new HashMap<String, String>();
                String[] fromCharacters = this.toUnicodeCharacters(from);
                String[] toCharacters = this.toUnicodeCharacters(to);
                int fromLen = fromCharacters.length;
                int toLen = toCharacters.length;
                for (int i = 0; i < fromLen; ++i) {
                    String cFrom = fromCharacters[i];
                    if (characterMap.containsKey(cFrom)) continue;
                    if (i < toLen) {
                        characterMap.put(cFrom, toCharacters[i]);
                        continue;
                    }
                    characterMap.put(cFrom, null);
                }
                StringBuilder output = new StringBuilder(input.length());
                for (String cIn : this.toUnicodeCharacters(input)) {
                    if (characterMap.containsKey(cIn)) {
                        String cTo = (String)characterMap.get(cIn);
                        if (cTo == null) continue;
                        output.append(cTo);
                        continue;
                    }
                    output.append(cIn);
                }
                return output.toString();
            }

            private String[] toUnicodeCharacters(String s) {
                String[] result = new String[s.length()];
                int stringLength = 0;
                int slen = s.length();
                for (int i = 0; i < slen; ++i) {
                    block6: {
                        char c1 = s.charAt(i);
                        if (c1 >= '\ud800' && c1 <= '\udbff') {
                            try {
                                char c2 = s.charAt(i + 1);
                                if (c2 >= '\udc00' && c2 <= '\udfff') {
                                    result[stringLength] = (c1 + "" + c2).intern();
                                    ++i;
                                    break block6;
                                }
                                throw new IllegalArgumentException("Mismatched surrogate pair in translate function");
                            }
                            catch (StringIndexOutOfBoundsException ex) {
                                throw new IllegalArgumentException("High surrogate without low surrogate at end of string passed to translate function");
                            }
                        }
                        result[stringLength] = String.valueOf(c1).intern();
                    }
                    ++stringLength;
                }
                if (stringLength == result.length) {
                    return result;
                }
                String[] trimmed = new String[stringLength];
                System.arraycopy(result, 0, trimmed, 0, stringLength);
                return trimmed;
            }
        };
        NORMALIZE_SPACE = new Function("normalize-space", DataType.STRING, false, new DataType[]{DataType.STRING}){

            @Override
            public Object evaluate(Object ... args) {
                return this.normalize((String)args[0]);
            }

            public String normalize(String str) {
                char[] buffer = str.toCharArray();
                int write = 0;
                int lastWrite = 0;
                boolean wroteOne = false;
                int read = 0;
                while (read < buffer.length) {
                    if (this.isXMLSpace(buffer[read])) {
                        if (wroteOne) {
                            buffer[write++] = 32;
                        }
                        while (++read < buffer.length && this.isXMLSpace(buffer[read])) {
                        }
                        continue;
                    }
                    buffer[write++] = buffer[read++];
                    wroteOne = true;
                    lastWrite = write;
                }
                return new String(buffer, 0, lastWrite);
            }

            private boolean isXMLSpace(char c) {
                return c == ' ' || c == '\n' || c == '\r' || c == '\t';
            }
        };
        SUBSTRING = new Function("", "substring", DataType.STRING, false, 2, new DataType[]{DataType.STRING, DataType.NUMBER, DataType.NUMBER}){

            @Override
            public Object evaluate(Object ... args) {
                String str = (String)args[0];
                if (str == null) {
                    return "";
                }
                int stringLength = ((Double)LENGTH.evaluate(str)).intValue();
                if (stringLength == 0) {
                    return "";
                }
                Double d1 = (Double)args[1];
                if (d1.isNaN()) {
                    return "";
                }
                int start = ((Double)ROUND.evaluate(d1)).intValue() - 1;
                int substringLength = stringLength;
                if (args.length == 3) {
                    Double d2 = (Double)args[2];
                    substringLength = !d2.isNaN() ? ((Double)ROUND.evaluate(d2)).intValue() : 0;
                }
                if (substringLength < 0) {
                    return "";
                }
                int end = start + substringLength;
                if (args.length == 2) {
                    end = stringLength;
                }
                if (start < 0) {
                    start = 0;
                } else if (start > stringLength) {
                    return "";
                }
                if (end > stringLength) {
                    end = stringLength;
                } else if (end < start) {
                    return "";
                }
                if (stringLength == str.length()) {
                    return str.substring(start, end);
                }
                return this.unicodeSubstring(str, start, end);
            }

            private String unicodeSubstring(String s, int start, int end) {
                StringBuffer result = new StringBuffer(s.length());
                int jChar = 0;
                for (int uChar = 0; uChar < end; ++uChar) {
                    char c = s.charAt(jChar);
                    if (uChar >= start) {
                        result.append(c);
                    }
                    if (c >= '\ud800') {
                        ++jChar;
                        if (uChar >= start) {
                            result.append(s.charAt(jChar));
                        }
                    }
                    ++jChar;
                }
                return result.toString();
            }
        };
        UPPER_CASE = new ChangeCase("upper-case"){

            @Override
            protected String evaluate(String arg, Locale locale) {
                return arg.toUpperCase(locale);
            }
        };
        LOWER_CASE = new ChangeCase("lower-case"){

            @Override
            protected String evaluate(String arg, Locale locale) {
                return arg.toLowerCase(locale);
            }
        };
        AND = new PeekingFunction("and", DataType.BOOLEAN, false, new DataType[]{DataType.BOOLEAN, DataType.BOOLEAN}){

            @Override
            public Object evaluate(Object ... args) {
                return (Boolean)args[0] != false && (Boolean)args[1] != false;
            }

            @Override
            protected Object onMemberResult(int index, Object result) {
                return result == Boolean.FALSE ? result : null;
            }
        };
        OR = new PeekingFunction("or", DataType.BOOLEAN, false, new DataType[]{DataType.BOOLEAN, DataType.BOOLEAN}){

            @Override
            public Object evaluate(Object ... args) {
                return (Boolean)args[0] != false || (Boolean)args[1] != false;
            }

            @Override
            protected Object onMemberResult(int index, Object result) {
                return result == Boolean.TRUE ? result : null;
            }
        };
        NOT = new Function("not", DataType.BOOLEAN, false, new DataType[]{DataType.BOOLEAN}){

            @Override
            public Object evaluate(Object ... args) {
                return (Boolean)args[0] == false;
            }
        };
        NUMBER_EQUALS_NUMBER = new PeekingFunction("=", DataType.BOOLEAN, false, new DataType[]{DataType.NUMBER, DataType.NUMBER}){

            @Override
            public Object evaluate(Object ... args) {
                return args[0].equals(args[1]);
            }

            @Override
            protected Object onMemberResult(int index, Object result) {
                return Double.isNaN((Double)result) ? Boolean.FALSE : null;
            }
        };
        STRING_EQUALS_STRING = new Function("=", DataType.BOOLEAN, false, new DataType[]{DataType.STRING, DataType.STRING}){

            @Override
            public Object evaluate(Object ... args) {
                assert (args[0] instanceof String);
                assert (args[1] instanceof String);
                return args[0].equals(args[1]);
            }
        };
        STRINGS_EQUALS_STRING = new PeekingFunction("=", DataType.BOOLEAN, false, new DataType[]{DataType.STRINGS, DataType.STRING}){

            @Override
            public Object evaluate(Object ... args) {
                assert (args[1] instanceof String);
                if (args[0] instanceof Collection) {
                    return ((Collection)args[0]).contains(args[1]);
                }
                return args[0].equals(args[1]);
            }

            @Override
            protected Object onMemberResult(int index, Object result) {
                return result instanceof Collection && ((Collection)result).size() == 0 ? Boolean.FALSE : null;
            }
        };
        NUMBERS_EQUALS_NUMBER = new PeekingFunction("=", DataType.BOOLEAN, false, new DataType[]{DataType.NUMBERS, DataType.NUMBER}){

            @Override
            public Object evaluate(Object ... args) {
                double rhs = (Double)args[1];
                if (Double.isNaN(rhs)) {
                    return false;
                }
                if (args[0] instanceof Collection) {
                    return ((Collection)args[0]).contains(args[1]);
                }
                return (Double)args[0] == rhs;
            }

            @Override
            protected Object onMemberResult(int index, Object result) {
                if (result instanceof Double) {
                    return Double.isNaN((Double)result) ? Boolean.FALSE : null;
                }
                return ((Collection)result).size() == 0 ? Boolean.FALSE : null;
            }
        };
        STRINGS_EQUALS_STRINGS = new PeekingFunction("=", DataType.BOOLEAN, false, new DataType[]{DataType.STRINGS, DataType.STRINGS}){

            @Override
            public Object evaluate(Object ... args) {
                boolean list0 = args[0] instanceof Collection;
                boolean list1 = args[1] instanceof Collection;
                if (list0 && list1) {
                    Collection rhs = (Collection)args[1];
                    for (Object lhs : (Collection)args[0]) {
                        if (!rhs.contains(lhs)) continue;
                        return true;
                    }
                    return false;
                }
                if (list0) {
                    return ((Collection)args[0]).contains(args[1]);
                }
                if (list1) {
                    return ((Collection)args[1]).contains(args[0]);
                }
                return args[0].equals(args[1]);
            }

            @Override
            protected Object onMemberResult(int index, Object result) {
                return result instanceof Collection && ((Collection)result).size() == 0 ? Boolean.FALSE : null;
            }
        };
        EQUALS = new Equality("="){

            @Override
            protected boolean evaluateObjects(Object lhs, Object rhs) {
                if (lhs instanceof Double && (Double.isNaN((Double)lhs) || Double.isNaN((Double)rhs))) {
                    return false;
                }
                return lhs.equals(rhs);
            }

            @Override
            protected final Object onMemberResult(int index, Object result) {
                if (result instanceof Double) {
                    return Double.isNaN((Double)result) ? Boolean.FALSE : null;
                }
                return super.onMemberResult(index, result);
            }
        };
        NOT_EQUALS = new Equality("!="){

            @Override
            protected boolean evaluateObjects(Object lhs, Object rhs) {
                if (lhs instanceof Double && (Double.isNaN((Double)lhs) || Double.isNaN((Double)rhs))) {
                    return true;
                }
                return !lhs.equals(rhs);
            }

            @Override
            protected final Object onMemberResult(int index, Object result) {
                if (result instanceof Double) {
                    return Double.isNaN((Double)result) ? Boolean.TRUE : null;
                }
                return super.onMemberResult(index, result);
            }
        };
        GREATER_THAN = new Relational(">"){

            @Override
            protected boolean evaluateDoubles(double lhs, double rhs) {
                return lhs > rhs;
            }
        };
        GREATER_THAN_EQUAL = new Relational(">="){

            @Override
            protected boolean evaluateDoubles(double lhs, double rhs) {
                return lhs >= rhs;
            }
        };
        LESS_THAN = new Relational("<"){

            @Override
            protected boolean evaluateDoubles(double lhs, double rhs) {
                return lhs < rhs;
            }
        };
        LESS_THAN_EQUAL = new Relational("<="){

            @Override
            protected boolean evaluateDoubles(double lhs, double rhs) {
                return lhs <= rhs;
            }
        };
        library = new HashMap<String, Function>();
        for (Function f : functions = new Function[]{ADD, SUBSTRACT, MULTIPLY, DIV, MOD, CEIL, FLOOR, ROUND, LENGTH, STARTS_WITH, ENDS_WITH, CONTAINS, CONCAT, LANGUAGE_MATCH, TRANSLATE, NORMALIZE_SPACE, SUBSTRING, UPPER_CASE, LOWER_CASE, AND, OR, NOT, EQUALS, NOT_EQUALS, GREATER_THAN, GREATER_THAN_EQUAL, LESS_THAN, LESS_THAN_EQUAL, new TypeCast(DataType.STRING), new TypeCast(DataType.NUMBER), new TypeCast(DataType.BOOLEAN)}) {
            library.put(f.name, f);
        }
    }

    private static abstract class Relational
    extends PeekingFunction {
        public Relational(String name) {
            super(name, DataType.BOOLEAN, false, DataType.NUMBERS, DataType.NUMBERS);
        }

        @Override
        public final Object evaluate(Object[] args) {
            boolean list1 = args[0] instanceof Collection;
            boolean list2 = args[1] instanceof Collection;
            if (list1 && list2) {
                Collection rhsCollection = (Collection)args[1];
                for (Object lhs : (Collection)args[0]) {
                    double lhsNum = (Double)lhs;
                    if (Double.isNaN(lhsNum)) continue;
                    for (Object rhs : rhsCollection) {
                        double rhsNum = (Double)rhs;
                        if (Double.isNaN(rhsNum) || !this.evaluateDoubles(lhsNum, rhsNum)) continue;
                        return true;
                    }
                }
            } else if (list1) {
                double rhsNum = (Double)args[1];
                if (!Double.isNaN(rhsNum)) {
                    for (Object lhs : (Collection)args[0]) {
                        double lhsNum = (Double)lhs;
                        if (Double.isNaN(lhsNum) || !this.evaluateDoubles(lhsNum, rhsNum)) continue;
                        return true;
                    }
                }
            } else if (list2) {
                double lhsNum = (Double)args[0];
                if (!Double.isNaN(lhsNum)) {
                    for (Object rhs : (Collection)args[1]) {
                        double rhsNum = (Double)rhs;
                        if (Double.isNaN(rhsNum) || !this.evaluateDoubles(lhsNum, rhsNum)) continue;
                        return true;
                    }
                }
            } else {
                double lhsNum = (Double)args[0];
                if (Double.isNaN(lhsNum)) {
                    return false;
                }
                double rhsNum = (Double)args[1];
                return !Double.isNaN(rhsNum) && this.evaluateDoubles(lhsNum, rhsNum);
            }
            return false;
        }

        protected abstract boolean evaluateDoubles(double var1, double var3);

        @Override
        protected final Object onMemberResult(int index, Object result) {
            if (result instanceof Collection) {
                return ((Collection)result).size() == 0 ? Boolean.FALSE : null;
            }
            return ((Double)result).isNaN() ? Boolean.FALSE : null;
        }
    }

    private static abstract class Equality
    extends Comparison {
        public Equality(String name) {
            super(name, DataType.STRINGS);
        }

        @Override
        protected final boolean evaluateObjectObject(Object lhs, Object rhs) {
            assert (lhs != null && rhs != null);
            if (lhs instanceof Boolean || rhs instanceof Boolean) {
                return this.evaluateObjects(DataType.asBoolean(lhs), DataType.asBoolean(rhs));
            }
            if (lhs instanceof Double || rhs instanceof Double) {
                return this.evaluateObjects(DataType.asNumber(lhs), DataType.asNumber(rhs));
            }
            return this.evaluateObjects(lhs.toString(), rhs.toString());
        }

        protected abstract boolean evaluateObjects(Object var1, Object var2);
    }

    private static abstract class Comparison
    extends PeekingFunction {
        protected Comparison(String name, DataType memberType) {
            super(name, DataType.BOOLEAN, false, memberType, memberType);
        }

        @Override
        public final Object evaluate(Object[] args) {
            boolean list1 = args[0] instanceof Collection;
            boolean list2 = args[1] instanceof Collection;
            if (list1 && list2) {
                Collection rhsCollection = (Collection)args[1];
                for (Object lhs : (Collection)args[0]) {
                    for (Object rhs : rhsCollection) {
                        if (!this.evaluateObjectObject(lhs, rhs)) continue;
                        return true;
                    }
                }
            } else if (list1) {
                for (Object lhs : (Collection)args[0]) {
                    if (!this.evaluateObjectObject(lhs, args[1])) continue;
                    return true;
                }
            } else if (list2) {
                for (Object rhs : (Collection)args[1]) {
                    if (!this.evaluateObjectObject(args[0], rhs)) continue;
                    return true;
                }
            } else {
                return this.evaluateObjectObject(args[0], args[1]);
            }
            return false;
        }

        @Override
        protected Object onMemberResult(int index, Object result) {
            return result instanceof Collection && ((Collection)result).size() == 0 ? Boolean.FALSE : null;
        }

        protected abstract boolean evaluateObjectObject(Object var1, Object var2);
    }

    public static abstract class ChangeCase
    extends Function {
        protected ChangeCase(String name) {
            super("", name, DataType.STRING, false, 1, DataType.STRING, DataType.STRING);
        }

        @Override
        public Object evaluate(Object ... args) {
            Locale locale = Locale.ENGLISH;
            if (args.length > 1 && (locale = ChangeCase.findLocale((String)args[1])) == null) {
                locale = Locale.ENGLISH;
            }
            return this.evaluate((String)args[0], locale);
        }

        protected abstract String evaluate(String var1, Locale var2);

        public static Locale findLocale(String localeText) {
            StringTokenizer tokens = new StringTokenizer(localeText, "-");
            if (tokens.hasMoreTokens()) {
                String language = tokens.nextToken();
                if (!tokens.hasMoreTokens()) {
                    return ChangeCase.findLocaleForLanguage(language);
                }
                String country = tokens.nextToken();
                if (!tokens.hasMoreTokens()) {
                    return new Locale(language, country);
                }
                String variant = tokens.nextToken();
                return new Locale(language, country, variant);
            }
            return null;
        }

        private static Locale findLocaleForLanguage(String language) {
            for (Locale locale : Locale.getAvailableLocales()) {
                String variant;
                String country;
                if (!language.equals(locale.getLanguage()) || (country = locale.getCountry()) != null && country.length() != 0 || (variant = locale.getVariant()) != null && variant.length() != 0) continue;
                return locale;
            }
            return null;
        }
    }

    private static abstract class ArithmeticFunction
    extends PeekingFunction {
        protected ArithmeticFunction(String name) {
            super(name, DataType.NUMBER, false, DataType.NUMBER, DataType.NUMBER);
        }

        @Override
        protected final Object onMemberResult(int index, Object result) {
            Double d = (Double)result;
            return d.isNaN() || d.isInfinite() ? d : null;
        }
    }

    public static class UserFunction
    extends Function {
        public final XPathFunction xpathFunction;

        public UserFunction(String namespace, String name, XPathFunction xpathFunction) {
            super(namespace, name, DataType.PRIMITIVE, true, DataType.PRIMITIVE);
            this.xpathFunction = xpathFunction;
        }

        @Override
        public Object evaluate(Object ... args) {
            try {
                return this.xpathFunction.evaluate(Arrays.asList(args));
            }
            catch (XPathFunctionException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static class TypeCast
    extends Function {
        public TypeCast(DataType resultType) {
            super(resultType.name().toLowerCase(), resultType, false, DataType.PRIMITIVE);
        }

        @Override
        public Object evaluate(Object ... args) {
            return this.resultType.convert(args[0]);
        }
    }
}

