/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.expr.nodset;

import jlibs.xml.sax.dog.expr.Evaluation;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.LinkableEvaluation;
import jlibs.xml.sax.dog.expr.nodset.NodeSetListener;
import jlibs.xml.sax.dog.sniff.Event;

public final class PredicateEvaluation
extends LinkableEvaluation<Expression> {
    private final Event event;
    private Object resultItem;
    private final Expression predicate;
    private final Evaluation booleanEvaluation;
    protected Object result;
    public NodeSetListener nodeSetListener;

    public PredicateEvaluation(Expression expression, long order, Object resultItem, Event event, Expression predicate, Evaluation booleanEvaluation) {
        super(expression, order);
        this.resultItem = resultItem;
        this.event = event;
        this.predicate = predicate;
        this.booleanEvaluation = booleanEvaluation;
    }

    @Override
    public void start() {
        if (this.resultItem instanceof Evaluation) {
            Evaluation eval = (Evaluation)this.resultItem;
            eval.addListener(this);
            eval.start();
        }
        if (this.booleanEvaluation == null) {
            this.event.addListener(this.predicate, this);
        } else {
            this.booleanEvaluation.addListener(this);
            this.booleanEvaluation.start();
        }
    }

    @Override
    public void finished(Evaluation evaluation) {
        if (evaluation == this.resultItem) {
            this.resultItem = evaluation.getResult();
        } else {
            if (evaluation.getResult() == Boolean.TRUE) {
                this.result = this.resultItem;
            }
            this.fireFinished();
        }
    }

    @Override
    protected void fireFinished() {
        super.fireFinished();
        if (this.resultItem instanceof Evaluation) {
            ((Evaluation)this.resultItem).removeListener(this);
        }
    }

    @Override
    protected void dispose() {
        if (this.resultItem instanceof Evaluation) {
            ((Evaluation)this.resultItem).removeListener(this);
        } else if (this.nodeSetListener != null) {
            this.nodeSetListener.discard(this.order);
        }
        if (this.booleanEvaluation == null) {
            if (this.predicate.scope() == 1) {
                this.event.removeListener(this.predicate, this);
            }
        } else {
            this.booleanEvaluation.removeListener(this);
        }
    }

    @Override
    public Object getResult() {
        throw new UnsupportedOperationException();
    }
}

