/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.path;

import jlibs.xml.sax.dog.path.AxisListener;
import jlibs.xml.sax.dog.path.Constraint;
import jlibs.xml.sax.dog.path.Step;
import jlibs.xml.sax.dog.path.tests.NamespaceURI;
import jlibs.xml.sax.dog.path.tests.QName;
import jlibs.xml.sax.dog.sniff.Event;

public final class EventID {
    private final int type;
    public String location;
    public EventID previous;
    public boolean interestedInAttributes;
    public boolean interestedInNamespaces;
    public int interestedInText;
    private ConstraintEntry[][] listenersArray;
    private static boolean[][] empty = new boolean[8][14];
    private int activeCount;
    public int axisEntryCount;
    private AxisEntry[] axisEntries = new AxisEntry[6];
    private int d;
    private boolean subTreeFinished = false;
    private boolean parentLevelFinished = false;
    private boolean rootElementVisited;

    public EventID(int type, ConstraintEntry[][] listenersArray) {
        this.type = type;
        this.listenersArray = listenersArray;
        if (type != 9) {
            this.rootElementVisited = true;
        }
    }

    public boolean isEmpty(int axis) {
        return empty[axis][this.type];
    }

    private boolean checkState() {
        if (this.axisEntries[1] != null) assert (this.axisEntries[1].active);
        if (this.axisEntries[0] != null) assert (this.axisEntries[0].active);
        int active = this.activeCount;
        int total = this.axisEntryCount;
        int textCount = 0;
        for (AxisEntry entry : this.axisEntries) {
            if (entry == null) continue;
            assert (entry.constraintEntry != null);
            if (entry.active) {
                --active;
                ConstraintEntry constraintEntry = entry.constraintEntry;
                while (constraintEntry != null) {
                    int constraintID = constraintEntry.constraint.id;
                    if (constraintID == 0 || constraintID == 4) {
                        ++textCount;
                    }
                    constraintEntry = constraintEntry.next;
                }
            }
            --total;
            assert (active >= 0);
        }
        assert (active == 0 && total == 0);
        assert (this.interestedInText == textCount);
        return true;
    }

    public void addListener(Event event, Step step, AxisListener listener) {
        ConstraintEntry[] listeners;
        ConstraintEntry oldConstraintEntry;
        int axis = step.axis;
        assert (!this.isEmpty(axis));
        Constraint constraint = step.constraint;
        if (axis == 7) {
            if (constraint.matches(event)) {
                listener.onHit(this);
            }
            listener.expired();
            return;
        }
        if (axis == 6) {
            if (constraint.matches(event)) {
                listener.onHit(this);
                if (listener.manuallyExpired) {
                    return;
                }
            }
            axis = 3;
        }
        boolean active = true;
        int constraintID = constraint.id;
        switch (axis) {
            case 2: {
                if (this.type != 9 || constraintID != 4) break;
                listener.expired();
                return;
            }
            case 4: 
            case 5: {
                if (this.type != 1) break;
                active = false;
            }
        }
        AxisEntry entry = this.axisEntries[axis];
        if (entry == null) {
            this.axisEntries[axis] = entry = new AxisEntry(active);
            if (active) {
                ++this.activeCount;
            }
            ++this.axisEntryCount;
        }
        if ((oldConstraintEntry = (listeners = this.listenersArray[axis])[constraintID]) != null) {
            assert (entry.constraintEntry != null);
            listener.nextAxisListener = oldConstraintEntry.listener;
            oldConstraintEntry.listener = listener;
        } else {
            ConstraintEntry constraintEntry = new ConstraintEntry(constraint, listener);
            constraintEntry.next = entry.constraintEntry;
            entry.constraintEntry = constraintEntry;
            listeners[constraintID] = constraintEntry;
            if (constraintID == 0 || constraintID == 4) {
                ++entry.textCount;
                if (active) {
                    ++this.interestedInText;
                }
            }
        }
        assert (this.checkState());
    }

    public void listenersAdded() {
        int noOfConstraints = this.listenersArray[0].length;
        for (int iAxis = 0; iAxis < 6; ++iAxis) {
            ConstraintEntry[] listeners = this.listenersArray[iAxis];
            for (int iListener = 0; iListener < noOfConstraints; ++iListener) {
                listeners[iListener] = null;
            }
        }
        this.interestedInNamespaces = this.axisEntries[0] != null;
        this.interestedInAttributes = this.axisEntries[1] != null;
    }

    private void expire(int axis) {
        AxisEntry axisEntry = this.axisEntries[axis];
        if (axisEntry != null) {
            assert (axisEntry.active);
            ConstraintEntry constraintEntry = axisEntry.constraintEntry;
            do {
                this.expireList(constraintEntry.listener);
            } while ((constraintEntry = constraintEntry.next) != null);
            this.interestedInText -= axisEntry.textCount;
            this.axisEntries[axis] = null;
            --this.activeCount;
            --this.axisEntryCount;
        }
    }

    private void expireList(AxisListener listener) {
        AxisListener next;
        do {
            if (!listener.manuallyExpired) {
                listener.expired();
            }
            next = listener.nextAxisListener;
            listener.nextAxisListener = null;
        } while ((listener = next) != null);
    }

    private void inactivate(int axis) {
        AxisEntry axisEntry = this.axisEntries[axis];
        if (axisEntry != null && axisEntry.active) {
            axisEntry.active = false;
            this.interestedInText -= axisEntry.textCount;
            --this.activeCount;
        }
    }

    private void activate(int axis) {
        AxisEntry axisEntry = this.axisEntries[axis];
        if (axisEntry != null && !axisEntry.active) {
            axisEntry.active = true;
            this.interestedInText += axisEntry.textCount;
            ++this.activeCount;
        }
    }

    public boolean push() {
        assert (this.axisEntryCount != 0);
        ++this.d;
        switch (this.d) {
            case 1: {
                this.inactivate(4);
                break;
            }
            case 2: {
                if (this.interestedInNamespaces) {
                    this.expire(0);
                    this.interestedInNamespaces = false;
                }
                if (this.interestedInAttributes) {
                    this.expire(1);
                    this.interestedInAttributes = false;
                }
                this.inactivate(2);
            }
        }
        assert (this.checkState());
        return this.axisEntryCount == 0;
    }

    public boolean pop(boolean doc) {
        assert (this.axisEntryCount != 0);
        --this.d;
        if (doc) {
            this.expire(5);
        }
        switch (this.d) {
            case -1: {
                this.parentLevelFinished = true;
                this.expire(4);
                break;
            }
            case 0: {
                if (!this.subTreeFinished) {
                    this.subTreeFinished = true;
                    if (this.interestedInNamespaces) {
                        this.expire(0);
                        this.interestedInNamespaces = false;
                    }
                    if (this.interestedInAttributes) {
                        this.expire(1);
                        this.interestedInAttributes = false;
                    }
                    this.expire(2);
                    this.expire(3);
                }
                if (this.parentLevelFinished) break;
                this.activate(4);
                this.activate(5);
                break;
            }
            case 1: {
                if (this.subTreeFinished) break;
                this.activate(2);
            }
        }
        assert (this.checkState());
        return this.axisEntryCount == 0;
    }

    public boolean onEvent(Event event) {
        assert (this.axisEntryCount != 0);
        if (this.activeCount == 0) {
            return false;
        }
        int eventType = event.type();
        if (eventType == 13) {
            if (this.interestedInNamespaces && this.onEvent(event, this.axisEntries[0])) {
                this.axisEntries[0] = null;
                --this.activeCount;
                --this.axisEntryCount;
                this.interestedInNamespaces = false;
            }
        } else {
            if (this.interestedInNamespaces) {
                this.expire(0);
                this.interestedInNamespaces = false;
            }
            if (eventType == 2) {
                if (this.interestedInAttributes && this.onEvent(event, this.axisEntries[1])) {
                    this.axisEntries[1] = null;
                    --this.activeCount;
                    --this.axisEntryCount;
                    this.interestedInAttributes = false;
                }
            } else {
                if (this.interestedInAttributes) {
                    this.expire(1);
                    this.interestedInAttributes = false;
                }
                for (int i = 2; i < 6; ++i) {
                    AxisEntry axisEntry = this.axisEntries[i];
                    if (axisEntry == null || !axisEntry.active || !this.onEvent(event, axisEntry)) continue;
                    this.axisEntries[i] = null;
                    --this.activeCount;
                    --this.axisEntryCount;
                }
                if (!this.rootElementVisited && eventType == 1) {
                    this.rootElementVisited = true;
                    AxisEntry childEntry = this.axisEntries[2];
                    if (childEntry != null) {
                        assert (childEntry.active);
                        ConstraintEntry headConstraintEntry = null;
                        ConstraintEntry lastConstraintEntry = null;
                        ConstraintEntry constraintEntry = childEntry.constraintEntry;
                        do {
                            Constraint constraint = constraintEntry.constraint;
                            int constraintID = constraint.id;
                            if (constraintID == 3 || constraintID == 1 || constraintID == 2 || constraint instanceof NamespaceURI || constraint instanceof QName) {
                                this.expireList(constraintEntry.listener);
                                continue;
                            }
                            if (headConstraintEntry == null) {
                                headConstraintEntry = constraintEntry;
                            } else {
                                lastConstraintEntry.next = constraintEntry;
                            }
                            lastConstraintEntry = constraintEntry;
                        } while ((constraintEntry = constraintEntry.next) != null);
                        childEntry.constraintEntry = headConstraintEntry;
                        if (lastConstraintEntry != null) {
                            lastConstraintEntry.next = null;
                        }
                        if (headConstraintEntry == null) {
                            this.axisEntries[2] = null;
                            --this.activeCount;
                            --this.axisEntryCount;
                        }
                    }
                }
            }
        }
        assert (this.checkState());
        return this.axisEntryCount == 0;
    }

    private boolean onEvent(Event event, AxisEntry axisEntry) {
        assert (axisEntry.active);
        EventID eventID = null;
        ConstraintEntry headConstraintEntry = null;
        ConstraintEntry lastConstraintEntry = null;
        ConstraintEntry constraintEntry = axisEntry.constraintEntry;
        do {
            Constraint constraint = constraintEntry.constraint;
            boolean keep = true;
            if (constraint.matches(event)) {
                AxisListener headListener = null;
                AxisListener lastListener = null;
                AxisListener listener = constraintEntry.listener;
                do {
                    if (listener.manuallyExpired) continue;
                    if (eventID == null) {
                        eventID = event.getID();
                    }
                    listener.onHit(eventID);
                    if (listener.manuallyExpired) continue;
                    if (headListener == null) {
                        headListener = listener;
                    } else {
                        lastListener.nextAxisListener = listener;
                    }
                    lastListener = listener;
                } while ((listener = listener.nextAxisListener) != null);
                if (headListener == null) {
                    keep = false;
                    int constraintID = constraint.id;
                    if (constraintID == 0 || constraintID == 4) {
                        --axisEntry.textCount;
                        --this.interestedInText;
                    }
                } else {
                    constraintEntry.listener = headListener;
                    lastListener.nextAxisListener = null;
                }
            }
            if (!keep) continue;
            if (headConstraintEntry == null) {
                headConstraintEntry = constraintEntry;
            } else {
                lastConstraintEntry.next = constraintEntry;
            }
            lastConstraintEntry = constraintEntry;
        } while ((constraintEntry = constraintEntry.next) != null);
        if (headConstraintEntry == null) {
            return true;
        }
        axisEntry.constraintEntry = headConstraintEntry;
        lastConstraintEntry.next = null;
        return false;
    }

    static {
        boolean[] attr = empty[1];
        boolean[] namespace = empty[0];
        for (int i = 13; i > 0; --i) {
            if (i == 1) continue;
            attr[i] = true;
            namespace[i] = true;
        }
        boolean[] child = empty[2];
        boolean[] descendant = empty[3];
        for (int i = 13; i > 0; --i) {
            if (i == 9 || i == 1) continue;
            child[i] = true;
            descendant[i] = true;
        }
        boolean[] followingSibling = empty[4];
        followingSibling[9] = true;
        followingSibling[2] = true;
        followingSibling[13] = true;
        EventID.empty[5][9] = true;
    }

    public static class ConstraintEntry {
        Constraint constraint;
        AxisListener listener;
        ConstraintEntry next;

        public ConstraintEntry(Constraint constraint, AxisListener listener) {
            this.constraint = constraint;
            this.listener = listener;
        }
    }

    private static class AxisEntry {
        boolean active;
        int textCount;
        ConstraintEntry constraintEntry;

        public AxisEntry(boolean active) {
            this.active = active;
        }
    }
}

