/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.sniff;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jlibs.core.lang.ImpossibleException;
import jlibs.xml.sax.dog.sniff.Event;
import jlibs.xml.sax.dog.sniff.XMLBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMBuilder
extends XMLBuilder {
    private static final DocumentBuilder domBuilder;
    private Document document = domBuilder.newDocument();
    private Node curNode;

    @Override
    protected Object onStartDocument() {
        this.curNode = this.document;
        return this.curNode;
    }

    @Override
    protected Object onStartElement(Event event) {
        Element element = this.document.createElementNS(event.namespaceURI(), event.qualifiedName());
        if (this.curNode != null) {
            this.curNode.appendChild(element);
        }
        this.curNode = element;
        return this.curNode;
    }

    @Override
    protected Object onEvent(Event event) {
        switch (event.type()) {
            case 2: {
                Attr attr = this.document.createAttributeNS(event.namespaceURI(), event.qualifiedName());
                attr.setNodeValue(event.value());
                if (this.curNode != null) {
                    ((Element)this.curNode).setAttributeNodeNS(attr);
                }
                return attr;
            }
            case 8: {
                Comment comment = this.document.createComment(event.value());
                if (this.curNode != null) {
                    this.curNode.appendChild(comment);
                }
                return comment;
            }
            case 7: {
                ProcessingInstruction pi = this.document.createProcessingInstruction(event.localName(), event.value());
                if (this.curNode != null) {
                    this.curNode.appendChild(pi);
                }
                return pi;
            }
            case 3: {
                Text text = this.document.createTextNode(event.value());
                if (this.curNode != null) {
                    this.curNode.appendChild(text);
                }
                return text;
            }
            case 13: {
                String qname = event.localName().length() == 0 ? "xmlns" : "xmlns:" + event.localName();
                Attr attr = this.document.createAttributeNS("http://www.w3.org/2000/xmlns/", qname);
                attr.setNodeValue(event.value());
                if (this.curNode != null) {
                    ((Element)this.curNode).setAttributeNodeNS(attr);
                }
                return attr;
            }
        }
        throw new ImpossibleException("event.type: " + event.type());
    }

    @Override
    protected Object onEndElement() {
        this.curNode = this.curNode.getParentNode();
        return this.curNode;
    }

    @Override
    protected void onEndDocument() {
        this.document = null;
    }

    @Override
    protected void clearCurNode() {
        this.curNode = null;
    }

    @Override
    protected void removeFromParent(Object node) {
        if (node instanceof Attr) {
            Attr attr = (Attr)node;
            Element owner = attr.getOwnerElement();
            if (owner != null) {
                owner.removeAttributeNode(attr);
            }
        } else {
            Node child = (Node)node;
            Node parent = child.getParentNode();
            if (parent != null) {
                parent.removeChild(child);
            }
        }
    }

    @Override
    protected boolean hasParent() {
        return this.curNode.getParentNode() != null;
    }

    static {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            domBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }
}

