/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.expr.nodset;

import jlibs.core.util.LongTreeMap;
import jlibs.xml.sax.dog.expr.Evaluation;
import jlibs.xml.sax.dog.expr.EvaluationListener;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.nodset.PositionalEvaluation;
import jlibs.xml.sax.dog.expr.nodset.PositionalListeners;
import jlibs.xml.sax.dog.path.PositionalPredicate;
import jlibs.xml.sax.dog.sniff.Event;

public final class PositionMatches
extends EvaluationListener {
    final Expression predicate;
    final int positionListenerCount;
    final LongTreeMap<PositionalListeners> map = new LongTreeMap();
    PositionMatches next;
    PositionalEvaluation lastListenerHead;
    PositionalEvaluation lastListenerTail;
    PositionalListeners listeners;
    private int position = 0;
    private boolean expired;

    PositionMatches(PositionalPredicate positionalPredicate) {
        this.predicate = positionalPredicate.predicate;
        this.positionListenerCount = positionalPredicate.position;
    }

    public void addEvaluation(Event event) {
        Object result = event.evaluate(this.predicate);
        if (result != null) {
            this.listeners = new PositionalListeners(event.order(), (Boolean)result, this.positionListenerCount);
        } else {
            this.listeners = new PositionalListeners(event.evaluation, this.positionListenerCount);
            event.evaluation.addListener(this);
        }
        this.map.put(event.order(), (Object)this.listeners);
    }

    public void startEvaluation() {
        if (this.listeners.evaluation != null) {
            this.listeners.evaluation.start();
        } else {
            this.finished(this.listeners.order, this.listeners.result);
        }
    }

    public void expired() {
        this.expired = true;
        if (this.lastListenerHead != null) {
            this.checkLast();
        }
    }

    private void checkLast() {
        if (this.expired && this.map.isEmpty()) {
            Double last = this.position;
            PositionalEvaluation eval = this.lastListenerHead;
            while (eval != null) {
                eval.setResult(last);
                eval = eval.next;
            }
            this.lastListenerTail = null;
            this.lastListenerHead = null;
        }
    }

    @Override
    public void finished(Evaluation evaluation) {
        this.finished(evaluation.order, (Boolean)evaluation.getResult());
    }

    private void finished(long order, boolean accept) {
        if (accept) {
            ((PositionalListeners)this.map.get((long)order)).result = Boolean.TRUE;
        } else {
            ((PositionalListeners)this.map.remove(order)).setPosition(Double.NaN);
        }
        while (!this.map.isEmpty()) {
            LongTreeMap.Entry entry = this.map.firstEntry();
            if (((PositionalListeners)entry.value).result == Boolean.TRUE) {
                ++this.position;
                this.map.deleteEntry(entry);
                ((PositionalListeners)entry.value).setPosition(Double.valueOf(this.position));
                continue;
            }
            return;
        }
        if (this.lastListenerHead != null) {
            this.checkLast();
        }
    }

    public void dispose() {
        for (LongTreeMap.Entry entry = this.map.firstEntry(); entry != null; entry = entry.next()) {
            ((PositionalListeners)entry.value).evaluation.removeListener(this);
        }
        this.map.clear();
    }
}

