/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.expr.nodset;

import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.nodset.PositionMatches;
import jlibs.xml.sax.dog.expr.nodset.Positional;
import jlibs.xml.sax.dog.expr.nodset.PositionalEvaluation;
import jlibs.xml.sax.dog.expr.nodset.PositionalListeners;
import jlibs.xml.sax.dog.path.PositionalPredicate;
import jlibs.xml.sax.dog.sniff.Event;

public class PositionTracker {
    public int position;
    private PositionMatches positionMatchesHead;
    private PositionalEvaluation lastListenerHead;
    private PositionalEvaluation lastListenerTail;

    public PositionTracker(PositionalPredicate positionPredicate) {
        if (positionPredicate != null) {
            PositionMatches positionMatches = this.positionMatchesHead = new PositionMatches(positionPredicate);
            while ((positionPredicate = positionPredicate.next) != null) {
                positionMatches = positionMatches.next = new PositionMatches(positionPredicate);
            }
        }
    }

    private PositionMatches getPositionMatches(Expression predicate) {
        PositionMatches positionMatches = this.positionMatchesHead;
        do {
            if (positionMatches.predicate != predicate) continue;
            return positionMatches;
        } while ((positionMatches = positionMatches.next) != null);
        return null;
    }

    void addPositionListener(PositionalEvaluation evaluation) {
        PositionMatches positionMatches = this.getPositionMatches(((Positional)evaluation.expression).predicate);
        assert (positionMatches.map.lastEntry().value == positionMatches.listeners);
        positionMatches.listeners.addListener(evaluation);
    }

    void removePositionListener(PositionalEvaluation evaluation) {
        PositionMatches positionMatches = this.getPositionMatches(((Positional)evaluation.expression).predicate);
        PositionalListeners positionalListeners = (PositionalListeners)positionMatches.map.get(evaluation.order);
        if (positionalListeners == null) {
            evaluation.disposed = true;
        } else {
            positionalListeners.removeListener(evaluation);
        }
    }

    void addLastLitener(PositionalEvaluation evaluation) {
        Expression predicate = ((Positional)evaluation.expression).predicate;
        if (predicate == null) {
            if (this.lastListenerTail == null) {
                this.lastListenerHead = this.lastListenerTail = evaluation;
            } else {
                this.lastListenerTail.next = evaluation;
                evaluation.previous = this.lastListenerTail;
                this.lastListenerTail = evaluation;
            }
        } else {
            PositionMatches matches = this.getPositionMatches(predicate);
            if (matches.lastListenerTail == null) {
                matches.lastListenerHead = matches.lastListenerTail = evaluation;
            } else {
                matches.lastListenerTail.next = evaluation;
                evaluation.previous = matches.lastListenerTail;
                matches.lastListenerTail = evaluation;
            }
        }
    }

    void removeLastLitener(PositionalEvaluation evaluation) {
        PositionalEvaluation prev = evaluation.previous;
        PositionalEvaluation next = evaluation.next;
        Expression predicate = ((Positional)evaluation.expression).predicate;
        if (predicate == null) {
            if (prev != null) {
                prev.next = next;
            } else {
                this.lastListenerHead = next;
            }
            if (next != null) {
                next.previous = prev;
            } else {
                this.lastListenerTail = prev;
            }
        } else {
            PositionMatches matches = this.getPositionMatches(predicate);
            if (prev != null) {
                prev.next = next;
            } else {
                matches.lastListenerHead = next;
            }
            if (next != null) {
                next.previous = prev;
            } else {
                matches.lastListenerTail = prev;
            }
        }
    }

    public void addEvaluation(Event event) {
        ++this.position;
        if (this.positionMatchesHead != null) {
            PositionMatches positionMatches = this.positionMatchesHead;
            do {
                positionMatches.addEvaluation(event);
            } while ((positionMatches = positionMatches.next) != null);
        }
    }

    public void startEvaluation() {
        if (this.positionMatchesHead != null) {
            PositionMatches positionMatches = this.positionMatchesHead;
            do {
                positionMatches.startEvaluation();
            } while ((positionMatches = positionMatches.next) != null);
        }
    }

    public void expired() {
        if (this.lastListenerHead != null) {
            Double last = this.position;
            PositionalEvaluation lastEval = this.lastListenerHead;
            while (lastEval != null) {
                lastEval.setResult(last);
                lastEval = lastEval.next;
            }
            this.lastListenerTail = null;
            this.lastListenerHead = null;
        }
        if (this.positionMatchesHead != null) {
            PositionMatches positionMatches = this.positionMatchesHead;
            do {
                positionMatches.expired();
            } while ((positionMatches = positionMatches.next) != null);
        }
    }
}

