/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.expr.nodset;

import java.util.ArrayList;
import java.util.List;
import jlibs.xml.sax.dog.DataType;
import jlibs.xml.sax.dog.expr.Evaluation;
import jlibs.xml.sax.dog.expr.EvaluationListener;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.nodset.Strings;
import jlibs.xml.sax.dog.path.AxisListener;
import jlibs.xml.sax.dog.path.EventID;
import jlibs.xml.sax.dog.path.Step;
import jlibs.xml.sax.dog.path.tests.Text;
import jlibs.xml.sax.dog.sniff.Event;

public final class StringEvaluation
extends AxisListener<Strings> {
    private static final Step DESCENDANT_TEXT_STEP = new Step(3, Text.INSTANCE);
    private StringBuilder buff = new StringBuilder(50);
    private Event event;
    private EventID eventID;
    private ArrayList<EvaluationListener> numberListeners = new ArrayList();
    private ArrayList<EvaluationListener> stringListeners = new ArrayList();
    private boolean firing;
    private Object result;

    protected StringEvaluation(Strings expression, Event event) {
        super(expression, event.order());
        this.event = event;
        this.eventID = event.getID();
    }

    @Override
    public void start() {
        this.eventID.addListener(this.event, DESCENDANT_TEXT_STEP, this);
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public void finished(Evaluation evaluation) {
    }

    @Override
    public void onHit(EventID eventID) {
        StringBuilder str = this.event.buff;
        this.buff.append((CharSequence)str);
        if (this.numberListeners.size() > 0) {
            for (int i = str.length() - 1; i >= 0; --i) {
                char ch = str.charAt(i);
                if (Character.isDigit(ch) || ch == '.' || ch == '+' || ch == '-') continue;
                this.fireFinished(this.numberListeners, Double.NaN);
                if (this.stringListeners.size() == 0) {
                    this.manuallyExpired = true;
                }
                return;
            }
        } else if (this.stringListeners.size() == 0) {
            this.manuallyExpired = true;
        }
    }

    @Override
    public void expired() {
        this.fireFinished();
    }

    @Override
    public void addListener(EvaluationListener listener) {
        this.addListener(this.expression, listener);
    }

    public void addListener(Expression expression, EvaluationListener listener) {
        if (expression.resultType == DataType.NUMBER || expression.resultType == DataType.NUMBERS) {
            this.numberListeners.add(listener);
        } else {
            this.stringListeners.add(listener);
        }
    }

    @Override
    public void removeListener(EvaluationListener listener) {
        this.removeListener(this.expression, listener);
    }

    public void removeListener(Expression expression, EvaluationListener listener) {
        if (this.firing) {
            listener.disposed = true;
        } else if (expression.resultType == DataType.NUMBER || expression.resultType == DataType.NUMBERS) {
            this.numberListeners.remove(listener);
        } else {
            this.stringListeners.remove(listener);
        }
    }

    private void fireFinished(List<EvaluationListener> listeners, Object result) {
        this.result = result;
        this.firing = true;
        for (EvaluationListener listener : listeners) {
            if (listener.disposed) continue;
            listener.finished(this);
        }
        this.firing = false;
        listeners.clear();
    }

    @Override
    protected void fireFinished() {
        if (this.stringListeners.size() > 0) {
            this.fireFinished(this.stringListeners, this.buff.toString());
        }
        if (this.numberListeners.size() > 0) {
            double d;
            try {
                d = Double.parseDouble(this.buff.toString());
            }
            catch (NumberFormatException ex) {
                d = Double.NaN;
            }
            this.fireFinished(this.numberListeners, d);
        }
    }

    @Override
    protected void dispose() {
        this.manuallyExpired = true;
    }
}

