/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog;

import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import jlibs.core.lang.ImpossibleException;

public final class DataType
extends Enum<DataType> {
    public static final /* enum */ DataType NODESET = new DataType(XPathConstants.NODESET, Collections.emptyMap());
    public static final /* enum */ DataType STRING = new DataType(XPathConstants.STRING, "");
    public static final /* enum */ DataType NUMBER = new DataType(XPathConstants.NUMBER, 0.0);
    public static final /* enum */ DataType BOOLEAN = new DataType(XPathConstants.BOOLEAN, false);
    public static final /* enum */ DataType STRINGS = new DataType(new QName("http://jlibs.org", "strings"), Collections.emptyList());
    public static final /* enum */ DataType NUMBERS = new DataType(new QName("http://jlibs.org", "numbers"), Collections.emptyList());
    public static final /* enum */ DataType PRIMITIVE = new DataType(new QName("http://jlibs.org", "primitive"), null);
    public final QName qname;
    public final Object defaultValue;
    public static final Double ZERO;
    public static final Double ONE;
    private static final /* synthetic */ DataType[] $VALUES;

    public static DataType[] values() {
        return (DataType[])$VALUES.clone();
    }

    public static DataType valueOf(String name) {
        return Enum.valueOf(DataType.class, name);
    }

    private DataType(QName qname, Object defaultValue) {
        this.qname = qname;
        this.defaultValue = defaultValue;
    }

    public Object convert(Object result) {
        switch (this) {
            case STRING: {
                return DataType.asString(result);
            }
            case BOOLEAN: {
                return DataType.asBoolean(result);
            }
            case NUMBER: {
                return DataType.asNumber(result);
            }
        }
        throw new UnsupportedOperationException("can't be converted to " + (Object)((Object)this));
    }

    public static boolean asBoolean(Object obj) {
        if (obj instanceof String) {
            return ((String)obj).length() > 0;
        }
        if (obj instanceof Double) {
            double number = (Double)obj;
            return number != 0.0 && !Double.isNaN(number);
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        throw new ImpossibleException(obj.getClass().getName());
    }

    public static double asNumber(Object obj) {
        if (obj instanceof String) {
            try {
                return Double.parseDouble((String)obj);
            }
            catch (NumberFormatException ex) {
                return Double.NaN;
            }
        }
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? ONE : ZERO;
        }
        throw new ImpossibleException(obj.getClass().getName());
    }

    public static String asString(Object obj) {
        return String.valueOf(obj);
    }

    public static DataType valueOf(Object literal) {
        if (literal instanceof String) {
            return STRING;
        }
        if (literal instanceof Number) {
            return NUMBER;
        }
        if (literal instanceof Boolean) {
            return BOOLEAN;
        }
        assert (literal instanceof List);
        return NODESET;
    }

    static {
        $VALUES = new DataType[]{NODESET, STRING, NUMBER, BOOLEAN, STRINGS, NUMBERS, PRIMITIVE};
        ZERO = 0.0;
        ONE = 1.0;
    }
}

