/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.expr.nodset;

import jlibs.core.util.LongTreeMap;
import jlibs.xml.sax.dog.DataType;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.Literal;
import jlibs.xml.sax.dog.expr.nodset.LocationExpression;
import jlibs.xml.sax.dog.path.LocationPath;
import jlibs.xml.sax.dog.sniff.Event;

public final class Count
extends LocationExpression {
    public Count(LocationPath locationPath) {
        super(locationPath, DataType.NUMBER, true, true);
    }

    @Override
    public Object getResult() {
        return this.locationPath == LocationPath.IMPOSSIBLE ? DataType.ZERO : DataType.ONE;
    }

    @Override
    protected Object getResultItem(Event event) {
        return DataType.ONE;
    }

    @Override
    protected Object getResult(LongTreeMap<Object> result) {
        if (this.rawResult) {
            return result;
        }
        return new Double(result.size());
    }

    @Override
    protected String getName() {
        return "count";
    }

    @Override
    public Expression simplify() {
        if (this.locationPath.scope == 2 && this.locationPath.steps.length == 0) {
            return new Literal(DataType.ONE, DataType.NUMBER);
        }
        return super.simplify();
    }
}

