/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.path;

import jlibs.xml.sax.dog.path.LocationPath;
import jlibs.xml.sax.dog.path.Step;
import jlibs.xml.sax.dog.path.tests.Element;
import jlibs.xml.sax.dog.path.tests.ParentNode;

public class LocationPathAnalyzer {
    public static LocationPath simplify(LocationPath path) {
        if (LocationPathAnalyzer.impossible(path)) {
            return LocationPath.IMPOSSIBLE;
        }
        path = LocationPathAnalyzer.discardSelfNode(path);
        if (path.steps.length > 0) {
            path = LocationPathAnalyzer.compressAnywhere(path);
            LocationPathAnalyzer.pnode_element(path);
        }
        return path;
    }

    private static boolean impossible(LocationPath path) {
        if (path.scope == 1 && path.steps.length > 0) {
            switch (path.steps[0].axis) {
                case 2: {
                    if (path.steps[0].constraint.id != 4) break;
                    return true;
                }
                case 0: 
                case 1: 
                case 4: 
                case 5: {
                    return true;
                }
            }
        }
        int lastAxis = -1;
        for (Step step : path.steps) {
            if (step.predicateSet.impossible) {
                return true;
            }
            if (step.axis == 4 && (lastAxis == 1 || lastAxis == 0)) {
                return true;
            }
            lastAxis = step.axis;
        }
        return false;
    }

    private static LocationPath discardSelfNode(LocationPath path) {
        int noOfNulls = 0;
        Step[] steps = path.steps;
        for (int i = steps.length - 1; i >= 0; --i) {
            Step step = steps[i];
            if (step.axis != 7 || step.constraint.id != 0 || step.predicateSet.hasPosition) continue;
            if (step.predicateSet.getPredicate() == null) {
                steps[i] = null;
                ++noOfNulls;
                continue;
            }
            if (i == 0) continue;
            steps[i] = null;
            steps[i - 1].setPredicate(step);
            ++noOfNulls;
        }
        return noOfNulls > 0 ? LocationPathAnalyzer.removeNullSteps(path, noOfNulls) : path;
    }

    private static LocationPath compressAnywhere(LocationPath path) {
        int noOfNulls = 0;
        Step[] steps = path.steps;
        Step prevStep = steps[0];
        int len = steps.length;
        for (int i = 1; i < len; ++i) {
            Step curStep = steps[i];
            if (!curStep.predicateSet.hasPosition && prevStep.predicateSet.getPredicate() == null && prevStep.axis == 6 && prevStep.constraint.id == 0 && curStep.axis == 2) {
                steps[i - 1] = null;
                Step newStep = new Step(3, curStep.constraint);
                newStep.setPredicate(curStep);
                steps[i] = curStep = newStep;
                ++noOfNulls;
            }
            prevStep = curStep;
        }
        return noOfNulls > 0 ? LocationPathAnalyzer.removeNullSteps(path, noOfNulls) : path;
    }

    private static void pnode_element(LocationPath path) {
        Step[] steps = path.steps;
        int len = steps.length;
        block4: for (int i = 1; i < len; ++i) {
            Step curStep = steps[i];
            switch (curStep.axis) {
                case 0: 
                case 1: {
                    Step prevStep = steps[i - 1];
                    if (prevStep.predicateSet.hasPosition || prevStep.constraint.id != 0) continue block4;
                    steps[i - 1] = new Step(prevStep.axis, Element.INSTANCE);
                    steps[i - 1].setPredicate(prevStep);
                    continue block4;
                }
                case 2: 
                case 3: {
                    Step prevStep = steps[i - 1];
                    if (prevStep.predicateSet.hasPosition || prevStep.constraint.id != 0) continue block4;
                    steps[i - 1] = new Step(prevStep.axis, ParentNode.INSTANCE);
                    steps[i - 1].setPredicate(prevStep);
                }
            }
        }
    }

    private static LocationPath removeNullSteps(LocationPath path, int noOfNulls) {
        LocationPath spath = new LocationPath(path.scope, path.steps.length - noOfNulls);
        int i = 0;
        for (Step step : path.steps) {
            if (step == null) continue;
            spath.steps[i] = step;
            ++i;
        }
        return spath;
    }
}

