/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.sniff;

import java.util.ArrayDeque;
import java.util.ArrayList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import jlibs.core.lang.NotImplementedException;
import jlibs.xml.sax.dog.DataType;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.Literal;
import jlibs.xml.sax.dog.expr.Variable;
import jlibs.xml.sax.dog.expr.func.Function;
import jlibs.xml.sax.dog.expr.func.FunctionCall;
import jlibs.xml.sax.dog.expr.func.Functions;
import jlibs.xml.sax.dog.expr.nodset.ExactPosition;
import jlibs.xml.sax.dog.expr.nodset.Language;
import jlibs.xml.sax.dog.expr.nodset.Last;
import jlibs.xml.sax.dog.expr.nodset.Position;
import jlibs.xml.sax.dog.path.Constraint;
import jlibs.xml.sax.dog.path.LocationPath;
import jlibs.xml.sax.dog.path.LocationPathAnalyzer;
import jlibs.xml.sax.dog.path.Predicated;
import jlibs.xml.sax.dog.path.Step;
import jlibs.xml.sax.dog.path.tests.Comment;
import jlibs.xml.sax.dog.path.tests.LocalName;
import jlibs.xml.sax.dog.path.tests.NamespaceURI;
import jlibs.xml.sax.dog.path.tests.Node;
import jlibs.xml.sax.dog.path.tests.PI;
import jlibs.xml.sax.dog.path.tests.PITarget;
import jlibs.xml.sax.dog.path.tests.QName;
import jlibs.xml.sax.dog.path.tests.Star;
import jlibs.xml.sax.dog.path.tests.Text;
import org.jaxen.saxpath.Axis;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathHandler;
import org.jaxen.saxpath.XPathReader;

public final class XPathParser
implements XPathHandler {
    private final NamespaceContext nsContext;
    private final XPathVariableResolver variableResolver;
    private final XPathFunctionResolver functionResolver;
    private final XPathReader reader = new org.jaxen.saxpath.base.XPathReader();
    private boolean allowDefaultPrefixMapping = false;
    private boolean documentContext;
    private Expression expr;
    private static final int[] axisMap = new int[]{-1, 2, 3, -1, -1, 4, -1, 5, -1, 1, 0, 7, 6, -1};
    private ArrayDeque<Step> stepStack = new ArrayDeque();
    private int predicateDepth;
    public boolean langInterested;
    private static final Object FILTER_FLAG = new Object();
    private static final Object PATH_FLAG = "PATH_FLAG";
    private ArrayDeque<ArrayDeque> frames = new ArrayDeque();
    private ArrayDeque peekFrame;
    public ArrayList constraints = new ArrayList();
    private NamespaceURIStub namespaceURIStub = new NamespaceURIStub();
    private LocalNameStub localNameStub = new LocalNameStub();
    private QNameStub qnameStub = new QNameStub();
    private PITargetStub piTargetStub = new PITargetStub();

    public XPathParser(NamespaceContext nsContext, XPathVariableResolver variableResolver, XPathFunctionResolver functionResolver) {
        this.nsContext = nsContext;
        this.variableResolver = variableResolver;
        this.functionResolver = functionResolver;
        this.reader.setXPathHandler((XPathHandler)this);
    }

    public boolean isAllowDefaultPrefixMapping() {
        return this.allowDefaultPrefixMapping;
    }

    public void setAllowDefaultPrefixMapping(boolean allow) {
        this.allowDefaultPrefixMapping = allow;
    }

    public Expression parse(String xpath, boolean documentContext) throws SAXPathException {
        this.documentContext = documentContext;
        this.frames.clear();
        this.peekFrame = null;
        this.stepStack.clear();
        this.predicateDepth = 0;
        this.expr = null;
        this.reader.parse(xpath);
        return this.expr;
    }

    public void startXPath() {
        this.pushFrame();
    }

    public void endXPath() {
        Object current = this.pop();
        this.expr = current instanceof Expression ? (Expression)current : ((LocationPath)current).typeCast(DataType.NODESET).simplify();
    }

    public void startAbsoluteLocationPath() {
        this.pushFrame();
    }

    public void endAbsoluteLocationPath() {
        this.endLocationPath(1, this.popFrame());
    }

    public void startRelativeLocationPath() {
        this.pushFrame();
    }

    public void endRelativeLocationPath() {
        ArrayDeque steps = this.popFrame();
        int scope = this.documentContext ? (this.peekFrame.size() == 2 && this.peekFrame.getFirst() == PATH_FLAG && this.peekFrame.getLast() instanceof LocationPath ? 2 : (this.predicateDepth == 0 ? 1 : 2)) : 2;
        this.endLocationPath(scope, steps);
    }

    private void endLocationPath(int scope, ArrayDeque steps) {
        LocationPath path = new LocationPath(scope, steps.size());
        steps.toArray(path.steps);
        this.push(LocationPathAnalyzer.simplify(path));
    }

    private void startStep(int axis, Constraint constraint) {
        int dogAxis = axisMap[axis];
        if (dogAxis == -1) {
            throw new UnsupportedOperationException("Axis " + Axis.lookup((int)axis) + " is not supported");
        }
        Step step = new Step(dogAxis, constraint);
        this.push(step);
        this.stepStack.addLast(step);
    }

    private void endStep() {
        this.stepStack.pollLast();
    }

    public void startNameStep(int axis, String prefix, String localName) throws SAXPathException {
        Constraint constraint;
        boolean star = localName.equals("*");
        if (star && prefix.length() == 0) {
            constraint = Star.INSTANCE;
        } else {
            String uri;
            String string = uri = !this.allowDefaultPrefixMapping && prefix.length() == 0 ? "" : this.nsContext.getNamespaceURI(prefix);
            if (uri == null) {
                throw new SAXPathException("undeclared prefix: " + prefix);
            }
            constraint = star ? this.namespaceURIStub.get(uri) : ("*".equals(uri) ? this.localNameStub.get(localName) : this.qnameStub.get(uri, localName));
        }
        this.startStep(axis, constraint);
    }

    public void endNameStep() {
        this.endStep();
    }

    public void startAllNodeStep(int axis) {
        this.startStep(axis, Node.INSTANCE);
    }

    public void endAllNodeStep() {
        this.endStep();
    }

    public void startTextNodeStep(int axis) {
        this.startStep(axis, Text.INSTANCE);
    }

    public void endTextNodeStep() {
        this.endStep();
    }

    public void startCommentNodeStep(int axis) {
        this.startStep(axis, Comment.INSTANCE);
    }

    public void endCommentNodeStep() {
        this.endStep();
    }

    public void startProcessingInstructionNodeStep(int axis, String name) {
        this.startStep(axis, name.length() == 0 ? PI.INSTANCE : this.piTargetStub.get(name));
    }

    public void endProcessingInstructionNodeStep() {
        this.endStep();
    }

    public void startPredicate() {
        ++this.predicateDepth;
    }

    public void endPredicate() {
        Expression predicateExpr;
        --this.predicateDepth;
        Object predicate = this.pop();
        Predicated predicated = (Predicated)this.peek();
        if (predicate instanceof Expression) {
            predicateExpr = (Expression)predicate;
            if (predicateExpr.resultType == DataType.NUMBER) {
                if (predicate instanceof Literal) {
                    Double d = (Double)predicateExpr.getResult();
                    int pos = d.intValue();
                    if (d != (double)pos) {
                        predicateExpr = new Literal(Boolean.FALSE, DataType.BOOLEAN);
                    } else {
                        Step step;
                        Step step2 = step = predicated instanceof Step ? (Step)predicated : null;
                        predicateExpr = step != null && (step.axis == 7 || (step.axis == 1 || step.axis == 0) && step.constraint instanceof QName || step.predicateSet.getPredicate() instanceof ExactPosition) ? new Literal(pos == 1, DataType.BOOLEAN) : new ExactPosition(pos);
                    }
                } else {
                    FunctionCall equals = new FunctionCall(Functions.NUMBER_EQUALS_NUMBER);
                    equals.addValidMember(new Position(), 0);
                    equals.addValidMember(predicateExpr, 1);
                    predicateExpr = equals;
                }
            } else {
                predicateExpr = Functions.typeCast(predicateExpr, DataType.BOOLEAN);
            }
        } else {
            predicateExpr = Functions.typeCast(predicate, DataType.BOOLEAN);
        }
        if (predicated instanceof LocationPath) {
            LocationPath path = (LocationPath)predicated;
            if (path.contexts.size() == 0) {
                LocationPath newPath = new LocationPath(2, 0);
                newPath.contexts.add(path);
                this.pop();
                this.push(newPath);
                predicated = newPath;
            }
        }
        predicated.addPredicate(predicateExpr);
    }

    public void literal(String literal) {
        this.push(new Literal(literal, DataType.STRING));
    }

    public void number(int number) {
        this.push(new Literal(new Double(number), DataType.NUMBER));
    }

    public void number(double number) {
        this.push(new Literal(new Double(number), DataType.NUMBER));
    }

    public void startUnaryExpr() {
    }

    public void endUnaryExpr(int operator) {
        FunctionCall functionCall = new FunctionCall(Functions.MULTIPLY);
        functionCall.addValidMember(new Literal(-1.0, DataType.NUMBER), 0);
        functionCall.addMember(this.pop(), 1);
        this.push(functionCall.simplify());
    }

    public void startEqualityExpr() {
    }

    public void endEqualityExpr(int operator) {
        this.endBinaryOperator(operator == 1 ? Functions.EQUALS : Functions.NOT_EQUALS);
    }

    public void startAdditiveExpr() {
    }

    public void endAdditiveExpr(int operator) {
        this.endBinaryOperator(operator == 7 ? Functions.ADD : Functions.SUBSTRACT);
    }

    public void startMultiplicativeExpr() {
    }

    public void endMultiplicativeExpr(int operator) {
        Functions.ArithmeticFunction function = operator == 9 ? Functions.MULTIPLY : (operator == 11 ? Functions.DIV : Functions.MOD);
        this.endBinaryOperator(function);
    }

    public void startRelationalExpr() {
    }

    public void endRelationalExpr(int operator) {
        Function function = operator == 3 ? Functions.LESS_THAN : (operator == 4 ? Functions.LESS_THAN_EQUAL : (operator == 5 ? Functions.GREATER_THAN : Functions.GREATER_THAN_EQUAL));
        this.endBinaryOperator(function);
    }

    public void startAndExpr() {
    }

    public void endAndExpr(boolean create) {
        if (create) {
            this.endBinaryOperator(Functions.AND);
        }
    }

    public void startOrExpr() {
    }

    public void endOrExpr(boolean create) {
        if (create) {
            this.endBinaryOperator(Functions.OR);
        }
    }

    private void endBinaryOperator(Function function) {
        FunctionCall functionCall = new FunctionCall(function);
        Object member2 = this.pop();
        Object member1 = this.pop();
        functionCall.addMember(member1, 0);
        functionCall.addMember(member2, 1);
        this.push(functionCall.simplify());
    }

    public void startFunction(String prefix, String name) throws SAXPathException {
        String uri;
        String string = uri = prefix.length() == 0 ? "" : this.nsContext.getNamespaceURI(prefix);
        if (uri == null) {
            throw new SAXPathException("undeclared prefix: " + prefix);
        }
        if (uri.length() > 0 && this.functionResolver == null) {
            throw new SAXPathException("FunctionResolver is required");
        }
        this.pushFrame();
        this.push(new javax.xml.namespace.QName(uri, name));
    }

    public void endFunction() throws SAXPathException {
        ArrayDeque params = this.popFrame();
        javax.xml.namespace.QName name = (javax.xml.namespace.QName)params.pollFirst();
        if (name.getNamespaceURI().length() == 0) {
            this.push(this.createFunction(name.getLocalPart(), params).simplify());
        } else {
            int noOfParams = params.size();
            XPathFunction function = this.functionResolver.resolveFunction(name, noOfParams);
            if (function == null) {
                throw new SAXPathException("Unknown Function: " + name);
            }
            FunctionCall functionCall = new FunctionCall(new Functions.UserFunction(name.getNamespaceURI(), name.getLocalPart(), function), noOfParams);
            for (int i = 0; i < noOfParams; ++i) {
                functionCall.addMember(params.pollFirst(), i);
            }
            this.push(functionCall);
        }
    }

    private Expression createFunction(String name, ArrayDeque params) throws SAXPathException {
        int noOfParams = params.size();
        switch (noOfParams) {
            case 0: {
                LocationPath locationPath = this.predicateDepth == 0 ? LocationPath.DOCUMENT_CONTEXT : LocationPath.LOCAL_CONTEXT;
                Expression expr = locationPath.apply(name);
                if (expr != null) {
                    return expr;
                }
                return this.createFunction(name, 0);
            }
            case 1: {
                Expression expr;
                if (name.equals("lang")) {
                    this.langInterested = true;
                    FunctionCall functionCall = new FunctionCall(Functions.LANGUAGE_MATCH);
                    functionCall.addValidMember(new Language(), 0);
                    functionCall.addMember(params.pollFirst(), 1);
                    return functionCall;
                }
                Object current = params.pollFirst();
                if (current instanceof LocationPath && (expr = ((LocationPath)current).apply(name)) != null) {
                    return expr;
                }
                FunctionCall functionCall = (FunctionCall)this.createFunction(name, 1);
                functionCall.addMember(current, 0);
                return functionCall;
            }
        }
        FunctionCall functionCall = (FunctionCall)this.createFunction(name, noOfParams);
        for (int i = 0; i < noOfParams; ++i) {
            functionCall.addMember(params.pollFirst(), i);
        }
        return functionCall;
    }

    private Expression createFunction(String name, int noOfMembers) throws SAXPathException {
        Function function;
        if (noOfMembers == 0) {
            if (name.equals("position")) {
                int axis;
                Step step = this.stepStack.peekLast();
                if (step != null && ((axis = step.axis) == 7 || (axis == 1 || axis == 0) && step.constraint instanceof QName || step.predicateSet.getPredicate() instanceof ExactPosition)) {
                    return new Literal(DataType.ONE, DataType.NUMBER);
                }
                return new Position();
            }
            if (name.equals("last")) {
                int axis;
                Step step = this.stepStack.peekLast();
                if (step != null && ((axis = step.axis) == 7 || (axis == 1 || axis == 0) && step.constraint instanceof QName || step.predicateSet.getPredicate() instanceof ExactPosition)) {
                    return new Literal(DataType.ONE, DataType.NUMBER);
                }
                return new Last();
            }
            if (name.equals("true")) {
                return new Literal(Boolean.TRUE, DataType.BOOLEAN);
            }
            if (name.equals("false")) {
                return new Literal(Boolean.FALSE, DataType.BOOLEAN);
            }
        }
        if ((function = Functions.library.get(name)) == null) {
            throw new SAXPathException("Unknown function: " + name);
        }
        return new FunctionCall(function, noOfMembers);
    }

    public void startUnionExpr() {
        this.pushFrame();
    }

    public void endUnionExpr(boolean create) {
        ArrayDeque stack = this.popFrame();
        if (create) {
            LocationPath result = new LocationPath(2, 0);
            result.addToContext((LocationPath)stack.pollFirst());
            result.addToContext((LocationPath)stack.pollFirst());
            this.push(result);
        } else {
            this.push(stack.peek());
        }
    }

    public void startFilterExpr() {
        this.push(FILTER_FLAG);
    }

    public void endFilterExpr() {
        Object obj = this.pop();
        if (this.pop() != FILTER_FLAG) {
            throw new NotImplementedException("FilterExpression");
        }
        this.push(obj);
    }

    public void startPathExpr() {
        this.push(PATH_FLAG);
    }

    public void endPathExpr() {
        Object relative = this.pop();
        Object context = this.pop();
        if (relative instanceof LocationPath && context instanceof LocationPath) {
            ((LocationPath)relative).pathExpression = true;
            ((LocationPath)relative).addToContext((LocationPath)context);
            context = this.pop();
        }
        if (context != PATH_FLAG) {
            throw new NotImplementedException("Path");
        }
        this.push(relative);
    }

    public void variableReference(String prefix, String variableName) throws SAXPathException {
        String uri;
        String string = uri = prefix.length() == 0 ? "" : this.nsContext.getNamespaceURI(prefix);
        if (uri == null) {
            throw new SAXPathException("undeclared prefix: " + prefix);
        }
        if (this.variableResolver == null) {
            throw new SAXPathException("VariableResolver is required");
        }
        this.push(new Variable(this.variableResolver, new javax.xml.namespace.QName(uri, variableName)));
    }

    private void pushFrame() {
        this.peekFrame = new ArrayDeque();
        this.frames.addLast(this.peekFrame);
    }

    private ArrayDeque popFrame() {
        ArrayDeque frame = this.frames.pollLast();
        this.peekFrame = this.frames.peekLast();
        return frame;
    }

    private void push(Object obj) {
        this.peekFrame.addLast(obj);
    }

    private Object pop() {
        return this.peekFrame.pollLast();
    }

    private Object peek() {
        return this.peekFrame.peekLast();
    }

    class PITargetStub {
        private String target;

        PITargetStub() {
        }

        public boolean equals(Object obj) {
            return obj instanceof PITarget && ((PITarget)obj).target.equals(this.target);
        }

        public PITarget get(String target) {
            this.target = target;
            int index = XPathParser.this.constraints.indexOf(this);
            if (index != -1) {
                return (PITarget)XPathParser.this.constraints.get(index);
            }
            PITarget constraint = new PITarget(7 + XPathParser.this.constraints.size(), target);
            XPathParser.this.constraints.add(constraint);
            return constraint;
        }
    }

    class QNameStub {
        private String namespaceURI;
        private String localName;

        QNameStub() {
        }

        public boolean equals(Object obj) {
            if (obj instanceof QName) {
                QName qname = (QName)obj;
                return qname.localName.equals(this.localName) && qname.namespaceURI.equals(this.namespaceURI);
            }
            return false;
        }

        public QName get(String namespaceURI, String localName) {
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            int index = XPathParser.this.constraints.indexOf(this);
            if (index != -1) {
                return (QName)XPathParser.this.constraints.get(index);
            }
            QName constraint = new QName(7 + XPathParser.this.constraints.size(), namespaceURI, localName);
            XPathParser.this.constraints.add(constraint);
            return constraint;
        }
    }

    class LocalNameStub {
        private String localName;

        LocalNameStub() {
        }

        public boolean equals(Object obj) {
            return obj instanceof LocalName && ((LocalName)obj).localName.equals(this.localName);
        }

        public LocalName get(String localName) {
            this.localName = localName;
            int index = XPathParser.this.constraints.indexOf(this);
            if (index != -1) {
                return (LocalName)XPathParser.this.constraints.get(index);
            }
            LocalName constraint = new LocalName(7 + XPathParser.this.constraints.size(), localName);
            XPathParser.this.constraints.add(constraint);
            return constraint;
        }
    }

    class NamespaceURIStub {
        private String namespaceURI;

        NamespaceURIStub() {
        }

        public boolean equals(Object obj) {
            return obj instanceof NamespaceURI && ((NamespaceURI)obj).namespaceURI.equals(this.namespaceURI);
        }

        public NamespaceURI get(String namespaceURI) {
            this.namespaceURI = namespaceURI;
            int index = XPathParser.this.constraints.indexOf(this);
            if (index != -1) {
                return (NamespaceURI)XPathParser.this.constraints.get(index);
            }
            NamespaceURI constraint = new NamespaceURI(7 + XPathParser.this.constraints.size(), namespaceURI);
            XPathParser.this.constraints.add(constraint);
            return constraint;
        }
    }
}

