/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog;

import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import jlibs.xml.sax.dog.NodeItem;
import jlibs.xml.sax.dog.expr.Evaluation;
import jlibs.xml.sax.dog.expr.EvaluationListener;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.sniff.Event;

public class XPathResults
extends EvaluationListener {
    private Event event;
    private Map<Expression, Object> results = new HashMap<Expression, Object>();

    public XPathResults(Event event) {
        this.event = event;
    }

    @Override
    public void finished(Evaluation evaluation) {
        this.results.put((Expression)evaluation.expression, evaluation.getResult());
    }

    public NamespaceContext getNamespaceContext() {
        return this.event.getNamespaceContext();
    }

    public Object getResult(Expression expr) {
        return this.results.get(expr);
    }

    public static void print(PrintStream out, String xpath, Object result) {
        out.printf("XPath: %s%n", xpath);
        XPathResults.print(out, result, 2);
    }

    private static void printIndent(PrintStream out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print(" ");
        }
    }

    private static void print(PrintStream out, Object result, int indent) {
        if (result instanceof Collection) {
            int i = 0;
            Collection c = (Collection)result;
            String format = "%0" + String.valueOf(c.size()).length() + "d: %s%n";
            for (Object item : c) {
                if (item instanceof Collection) {
                    XPathResults.printIndent(out, indent);
                    out.println("[");
                    XPathResults.print(out, item, indent + 2);
                    XPathResults.printIndent(out, indent);
                    out.println("]");
                    continue;
                }
                XPathResults.printIndent(out, indent);
                out.printf(format, ++i, item);
            }
        } else {
            XPathResults.printIndent(out, indent);
            if (result instanceof NodeItem) {
                ((NodeItem)result).printTo(out);
            } else {
                out.print(result);
            }
            out.println();
        }
    }

    public void printResult(PrintStream out, Expression expr) {
        XPathResults.print(out, expr.getXPath(), this.getResult(expr));
    }

    public void print(Iterable<Expression> expressions, PrintStream out) {
        for (Expression expr : expressions) {
            XPathResults.print(out, expr.getXPath(), this.getResult(expr));
            out.println();
        }
    }
}

