/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.expr.func;

import jlibs.core.lang.ArrayUtil;
import jlibs.xml.sax.dog.DataType;

public abstract class Function {
    public final String namespace;
    public final String name;
    public final DataType resultType;
    public final DataType[] memberTypes;
    public final boolean varArgs;
    public final int mandatory;
    private static final String[] operators = new String[]{"+", "-", "*", "div", "mod", "and", "or", "|", "=", "!=", ">", ">=", "<", "<="};

    protected Function(String name, DataType resultType, boolean varArgs, DataType ... memberTypes) {
        this("", name, resultType, varArgs, memberTypes.length, memberTypes);
    }

    protected Function(String namespace, String name, DataType resultType, boolean varArgs, DataType ... memberTypes) {
        this(namespace, name, resultType, varArgs, memberTypes.length, memberTypes);
    }

    protected Function(String namespace, String name, DataType resultType, boolean varArgs, int mandatory, DataType ... memberTypes) {
        this.namespace = namespace;
        this.name = name;
        this.resultType = resultType;
        this.memberTypes = memberTypes;
        this.varArgs = varArgs;
        this.mandatory = mandatory;
    }

    public final boolean canAccept(int noOfMembers) {
        return noOfMembers >= this.mandatory && (this.varArgs || noOfMembers <= this.memberTypes.length);
    }

    public final DataType memberType(int i) {
        return i < this.memberTypes.length ? this.memberTypes[i] : this.memberTypes[this.memberTypes.length - 1];
    }

    public abstract Object evaluate(Object ... var1);

    public final boolean isOperator() {
        return ArrayUtil.indexOf((Object[])operators, (Object)this.name) != -1;
    }
}

