/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.expr.func;

import jlibs.xml.ClarkName;
import jlibs.xml.sax.dog.DataType;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.Literal;
import jlibs.xml.sax.dog.expr.func.Function;
import jlibs.xml.sax.dog.expr.func.FunctionEvaluation;
import jlibs.xml.sax.dog.expr.func.Functions;
import jlibs.xml.sax.dog.expr.func.PeekingFunction;
import jlibs.xml.sax.dog.expr.func.PeekingFunctionEvaluation;
import jlibs.xml.sax.dog.expr.nodset.ExactPosition;
import jlibs.xml.sax.dog.expr.nodset.Position;
import jlibs.xml.sax.dog.expr.nodset.Strings;
import jlibs.xml.sax.dog.sniff.Event;

public final class FunctionCall
extends Expression {
    public final Function function;
    public final Expression[] members;

    public FunctionCall(Function function) {
        super(0, function.resultType);
        this.function = function;
        this.members = new Expression[function.mandatory];
    }

    public FunctionCall(Function function, int noOfMembers) {
        super(0, function.resultType);
        this.function = function;
        if (!function.canAccept(noOfMembers)) {
            throw new IllegalArgumentException(String.format("%s function cannot accept %d arguments", function.name, noOfMembers));
        }
        this.members = new Expression[noOfMembers];
    }

    private FunctionCall(Function function, Expression[] members, int scope) {
        super(scope, function.resultType);
        this.function = function;
        this.members = members;
    }

    public Expression addMember(Object member, int i) {
        assert (this.members[i] == null) : "overwriting exising member";
        Expression expr = Functions.typeCast(member, this.function.memberType(i));
        int memberScope = expr.scope();
        if (this.scope < memberScope) {
            this.scope = memberScope;
        }
        this.members[i] = expr;
        return this.members[i];
    }

    public Expression addValidMember(Expression member, int i) {
        assert (this.members[i] == null) : "overwriting exising member";
        assert (member == Functions.typeCast(member, this.function.memberType(i)));
        int memberScope = member.scope();
        if (this.scope < memberScope) {
            this.scope = memberScope;
        }
        this.members[i] = member;
        return this.members[i];
    }

    @Override
    public Object getResult() {
        Object[] memberResults = new Object[this.members.length];
        int i = 0;
        for (Expression member : this.members) {
            memberResults[i] = member.getResult();
            ++i;
        }
        return this.function.evaluate(memberResults);
    }

    @Override
    public Object getResult(Event event) {
        Function function = this.function;
        Expression[] members = this.members;
        PeekingFunction peekingFunction = function instanceof PeekingFunction ? (PeekingFunction)function : null;
        int pending = members.length;
        Object[] memberResults = new Object[pending];
        int len = pending;
        for (int i = 0; i < len; ++i) {
            Object memberResult = event.evaluate(members[i]);
            if (memberResult != null) {
                Object result;
                if (--pending > 0 && peekingFunction != null && (result = peekingFunction.onMemberResult(i, memberResult)) != null) {
                    return result;
                }
                memberResults[i] = memberResult;
                continue;
            }
            memberResults[i] = event.evaluation;
        }
        if (pending == 0) {
            return function.evaluate(memberResults);
        }
        if (peekingFunction != null) {
            return new PeekingFunctionEvaluation(this, event, memberResults, pending);
        }
        return new FunctionEvaluation(this, event, memberResults, pending);
    }

    @Override
    public Expression simplify() {
        if (this.scope == 0) {
            return super.simplify();
        }
        if (this.function == Functions.EQUALS) {
            if (this.scope == 2) {
                Double d = null;
                if (this.members[0] instanceof Position && this.members[1].scope() == 0) {
                    d = (Double)this.members[1].getResult();
                } else if (this.members[1] instanceof Position && this.members[0].scope() == 0) {
                    d = (Double)this.members[0].getResult();
                }
                if (d != null) {
                    int pos = d.intValue();
                    if (d != (double)pos) {
                        return new Literal(Boolean.FALSE, DataType.BOOLEAN);
                    }
                    return new ExactPosition(pos);
                }
            }
            DataType member0Type = this.members[0].resultType;
            DataType member1Type = this.members[1].resultType;
            if (member0Type == DataType.NUMBER) {
                if (member1Type == DataType.NUMBER) {
                    return new FunctionCall(Functions.NUMBER_EQUALS_NUMBER, this.members, this.scope);
                }
                if (member1Type == DataType.STRINGS) {
                    FunctionCall functionCall = new FunctionCall(Functions.NUMBERS_EQUALS_NUMBER);
                    Strings member1 = (Strings)this.members[1];
                    functionCall.members[0] = new Strings(member1.locationPath, DataType.NUMBERS, true, false);
                    functionCall.members[1] = this.members[0];
                    functionCall.scope = this.scope;
                    return functionCall;
                }
                System.out.println((Object)((Object)this.members[0].resultType) + "==" + (Object)((Object)this.members[1].resultType));
            } else if (member0Type == DataType.STRING) {
                if (member1Type == DataType.STRING) {
                    return new FunctionCall(Functions.STRING_EQUALS_STRING, this.members, this.scope);
                }
                if (member1Type == DataType.STRINGS) {
                    FunctionCall functionCall = new FunctionCall(Functions.STRINGS_EQUALS_STRING);
                    functionCall.members[0] = this.members[1];
                    functionCall.members[1] = this.members[0];
                    functionCall.scope = this.scope;
                    return functionCall;
                }
                System.out.println((Object)((Object)this.members[0].resultType) + "==" + (Object)((Object)this.members[1].resultType));
            } else if (member0Type == DataType.STRINGS) {
                if (member1Type == DataType.STRINGS) {
                    return new FunctionCall(Functions.STRINGS_EQUALS_STRINGS, this.members, this.scope);
                }
                if (member1Type == DataType.STRING) {
                    return new FunctionCall(Functions.STRINGS_EQUALS_STRING, this.members, this.scope);
                }
                if (member1Type == DataType.NUMBER) {
                    Strings member0 = (Strings)this.members[0];
                    this.members[0] = new Strings(member0.locationPath, DataType.NUMBERS, true, false);
                    return new FunctionCall(Functions.NUMBERS_EQUALS_NUMBER, this.members, this.scope);
                }
                System.out.println((Object)((Object)this.members[0].resultType) + "==" + (Object)((Object)this.members[1].resultType));
            } else {
                System.out.println((Object)((Object)this.members[0].resultType) + "==" + (Object)((Object)this.members[1].resultType));
            }
        }
        return this;
    }

    public String toString() {
        String separator = ", ";
        boolean operator = this.function.isOperator();
        if (operator) {
            separator = " " + this.function.name + " ";
        }
        StringBuilder buff = new StringBuilder();
        for (Expression member : this.members) {
            boolean enclose;
            if (buff.length() > 0) {
                buff.append(separator);
            }
            boolean bl = enclose = operator && member instanceof FunctionCall && ((FunctionCall)member).function.isOperator();
            if (enclose) {
                buff.append('(');
            }
            buff.append(member);
            if (!enclose) continue;
            buff.append(')');
        }
        if (separator.equals(", ")) {
            return String.format("%s(%s)", ClarkName.valueOf((String)this.function.namespace, (String)this.function.name), buff);
        }
        return buff.toString();
    }
}

