/*
 * Decompiled with CFR 0.152.
 */
package jlibs.xml.sax.dog.expr.func;

import jlibs.xml.sax.dog.expr.Evaluation;
import jlibs.xml.sax.dog.expr.Expression;
import jlibs.xml.sax.dog.expr.func.FunctionCall;
import jlibs.xml.sax.dog.sniff.Event;

class FunctionEvaluation
extends Evaluation<FunctionCall> {
    protected int pending;
    protected final Object[] memberResults;
    protected final Event event;
    protected Object result;

    public FunctionEvaluation(FunctionCall expression, Event event, Object[] memberResults, int pending) {
        super(expression, event.order());
        this.event = event;
        this.memberResults = memberResults;
        this.pending = pending;
    }

    @Override
    public final void start() {
        Object[] memberResults = this.memberResults;
        int len = memberResults.length;
        for (int i = 0; i < len; ++i) {
            Object memberResult = memberResults[i];
            if (memberResult instanceof Evaluation) {
                Evaluation eval = (Evaluation)memberResult;
                eval.addListener(this);
                eval.start();
            } else if (memberResult == null) {
                assert (((FunctionCall)this.expression).members[i].scope() == 1);
                this.event.addListener(((FunctionCall)this.expression).members[i], this);
            }
            if (this.result == null) continue;
            return;
        }
        if (this.result == null && this.pending == 0) {
            this.fireFinished();
        }
    }

    protected void setMemberResult(int i, Object memberResult) {
        this.memberResults[i] = memberResult;
        --this.pending;
    }

    @Override
    public final Object getResult() {
        return this.result;
    }

    @Override
    public final void finished(Evaluation evaluation) {
        assert (this.result == null) : "can't consume any child evaluation";
        Object item = evaluation.expression;
        Expression[] members = ((FunctionCall)this.expression).members;
        for (int i = members.length - 1; i >= 0; --i) {
            if (members[i] != item) continue;
            this.setMemberResult(i, evaluation.getResult());
            if (this.pending == 0) {
                this.fireFinished();
            }
            return;
        }
        assert (false) : "Impossible";
    }

    @Override
    protected final void fireFinished() {
        if (this.result == null) {
            this.result = ((FunctionCall)this.expression).function.evaluate(this.memberResults);
        }
        super.fireFinished();
    }

    @Override
    protected final void dispose() {
        assert (this.pending != 0);
        int len = this.memberResults.length;
        for (int i = 0; i < len; ++i) {
            Object memberResult = this.memberResults[i];
            if (memberResult instanceof Evaluation) {
                ((Evaluation)memberResult).removeListener(this);
                continue;
            }
            if (memberResult != null) continue;
            assert (((FunctionCall)this.expression).members[i].scope() == 1);
            this.event.removeListener(((FunctionCall)this.expression).members[i], this);
        }
    }
}

